/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.assertj.core.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import shadow.org.assertj.core.api.AssertionInfo;
import shadow.org.assertj.core.error.ClassModifierShouldBe;
import shadow.org.assertj.core.error.ShouldBeAnnotation;
import shadow.org.assertj.core.error.ShouldBeAssignableFrom;
import shadow.org.assertj.core.error.ShouldBeInterface;
import shadow.org.assertj.core.error.ShouldHaveAnnotations;
import shadow.org.assertj.core.error.ShouldHaveFields;
import shadow.org.assertj.core.error.ShouldHaveMethods;
import shadow.org.assertj.core.error.ShouldHaveNoFields;
import shadow.org.assertj.core.error.ShouldOnlyHaveFields;
import shadow.org.assertj.core.internal.ComparisonStrategy;
import shadow.org.assertj.core.internal.Failures;
import shadow.org.assertj.core.internal.Objects;
import shadow.org.assertj.core.internal.StandardComparisonStrategy;
import shadow.org.assertj.core.util.Arrays;
import shadow.org.assertj.core.util.Lists;
import shadow.org.assertj.core.util.Preconditions;
import shadow.org.assertj.core.util.Sets;

public class Classes {
    private static final Classes INSTANCE = new Classes();
    private Failures failures = Failures.instance();
    private ComparisonStrategy comparisonStrategy = StandardComparisonStrategy.instance();

    public static Classes instance() {
        return INSTANCE;
    }

    public void assertIsAssignableFrom(AssertionInfo info, Class<?> actual, Class<?> ... others) {
        Classes.assertNotNull(info, actual);
        Preconditions.checkArgument(!Arrays.isNullOrEmpty(others), "Expecting at least one Class to be specified", new Object[0]);
        LinkedHashSet<Class<?>> expected = Sets.newLinkedHashSet(others);
        LinkedHashSet missing = new LinkedHashSet();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.isAssignableFrom(clazz)) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info, ShouldBeAssignableFrom.shouldBeAssignableFrom(actual, expected, missing));
        }
    }

    public void assertIsNotInterface(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (actual.isInterface()) {
            throw this.failures.failure(info, ShouldBeInterface.shouldNotBeInterface(actual));
        }
    }

    public void assertIsInterface(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!actual.isInterface()) {
            throw this.failures.failure(info, ShouldBeInterface.shouldBeInterface(actual));
        }
    }

    public void assertIsNotAnnotation(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (actual.isAnnotation()) {
            throw this.failures.failure(info, ShouldBeAnnotation.shouldNotBeAnnotation(actual));
        }
    }

    public void assertIsAnnotation(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!actual.isAnnotation()) {
            throw this.failures.failure(info, ShouldBeAnnotation.shouldBeAnnotation(actual));
        }
    }

    public void assertIsFinal(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info, ClassModifierShouldBe.shouldBeFinal(actual));
        }
    }

    public void assertIsPublic(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!Modifier.isPublic(actual.getModifiers())) {
            throw this.failures.failure(info, ClassModifierShouldBe.shouldBePublic(actual));
        }
    }

    public void assertIsProtected(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (!Modifier.isProtected(actual.getModifiers())) {
            throw this.failures.failure(info, ClassModifierShouldBe.shouldBeProtected(actual));
        }
    }

    public void assertIsNotFinal(AssertionInfo info, Class<?> actual) {
        Classes.assertNotNull(info, actual);
        if (Modifier.isFinal(actual.getModifiers())) {
            throw this.failures.failure(info, ClassModifierShouldBe.shouldNotBeFinal(actual));
        }
    }

    public void assertContainsAnnotations(AssertionInfo info, Class<?> actual, Class<? extends Annotation> ... annotations) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<Class<? extends Annotation>> expected = Sets.newLinkedHashSet(annotations);
        LinkedHashSet<Class<? extends Annotation>> missing = new LinkedHashSet<Class<? extends Annotation>>();
        for (Class clazz : expected) {
            Classes.classParameterIsNotNull(clazz);
            if (actual.getAnnotation(clazz) != null) continue;
            missing.add(clazz);
        }
        if (!missing.isEmpty()) {
            throw this.failures.failure(info, ShouldHaveAnnotations.shouldHaveAnnotations(actual, expected, missing));
        }
    }

    public void assertHasPublicFields(AssertionInfo info, Class<?> actual, String ... fields) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getFields()));
        if (expectedFieldNames.isEmpty()) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveNoFields.shouldHaveNoPublicFields(actual, actualFieldNames));
        }
        if (Classes.noMissingElement(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveFields.shouldHaveFields(actual, expectedFieldNames, missingFieldNames));
    }

    public void assertHasOnlyPublicFields(AssertionInfo info, Class<?> actual, String ... expectedFields) {
        Classes.assertNotNull(info, actual);
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getFields()));
        ArrayList<String> notExpected = Lists.newArrayList(actualFieldNames);
        ArrayList<String> notFound = Lists.newArrayList(expectedFields);
        if (expectedFields.length == 0) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveNoFields.shouldHaveNoPublicFields(actual, actualFieldNames));
        }
        for (String field : expectedFields) {
            if (!this.comparisonStrategy.iterableContains(notExpected, field)) continue;
            this.comparisonStrategy.iterablesRemoveFirst(notExpected, field);
            this.comparisonStrategy.iterablesRemoveFirst(notFound, field);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldOnlyHaveFields.shouldOnlyHaveFields(actual, Lists.newArrayList(expectedFields), notFound, notExpected));
    }

    private static boolean noMissingElement(Set<String> actualNames, Set<String> expectedNames, Set<String> missingNames) {
        for (String field : expectedNames) {
            if (actualNames.contains(field)) continue;
            missingNames.add(field);
        }
        return missingNames.isEmpty();
    }

    public void assertHasDeclaredFields(AssertionInfo info, Class<?> actual, String ... fields) {
        Classes.assertNotNull(info, actual);
        LinkedHashSet<String> expectedFieldNames = Sets.newLinkedHashSet(fields);
        LinkedHashSet<String> missingFieldNames = Sets.newLinkedHashSet();
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getDeclaredFields()));
        if (expectedFieldNames.isEmpty()) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveNoFields.shouldHaveNoDeclaredFields(actual, actualFieldNames));
        }
        if (Classes.noMissingElement(actualFieldNames, expectedFieldNames, missingFieldNames)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveFields.shouldHaveDeclaredFields(actual, expectedFieldNames, missingFieldNames));
    }

    public void assertHasOnlyDeclaredFields(AssertionInfo info, Class<?> actual, String ... expectedFields) {
        Classes.assertNotNull(info, actual);
        Set<String> actualFieldNames = Classes.fieldsToName(Classes.filterSyntheticMembers((Member[])actual.getDeclaredFields()));
        ArrayList<String> notExpected = Lists.newArrayList(actualFieldNames);
        ArrayList<String> notFound = Lists.newArrayList(expectedFields);
        if (expectedFields.length == 0) {
            if (actualFieldNames.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveNoFields.shouldHaveNoDeclaredFields(actual, actualFieldNames));
        }
        for (String field : expectedFields) {
            if (!this.comparisonStrategy.iterableContains(notExpected, field)) continue;
            this.comparisonStrategy.iterablesRemoveFirst(notExpected, field);
            this.comparisonStrategy.iterablesRemoveFirst(notFound, field);
        }
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldOnlyHaveFields.shouldOnlyHaveDeclaredFields(actual, Lists.newArrayList(expectedFields), notFound, notExpected));
    }

    private static Set<String> fieldsToName(Set<Field> fields) {
        return fields.stream().map(Field::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public void assertHasMethods(AssertionInfo info, Class<?> actual, String ... methods) {
        Classes.assertNotNull(info, actual);
        this.doAssertHasMethods(info, actual, Classes.filterSyntheticMembers((Member[])Classes.getAllMethods(actual)), false, methods);
    }

    public void assertHasDeclaredMethods(AssertionInfo info, Class<?> actual, String ... methods) {
        Classes.assertNotNull(info, actual);
        this.doAssertHasMethods(info, actual, Classes.filterSyntheticMembers((Member[])actual.getDeclaredMethods()), true, methods);
    }

    private void doAssertHasMethods(AssertionInfo info, Class<?> actual, Set<Method> actualMethods, boolean declared, String ... expectedMethods) {
        TreeSet<String> expectedMethodNames = Sets.newTreeSet(expectedMethods);
        TreeSet<String> missingMethodNames = Sets.newTreeSet();
        SortedSet<String> actualMethodNames = Classes.methodsToName(actualMethods);
        if (expectedMethods.length == 0) {
            if (actualMethods.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ShouldHaveMethods.shouldNotHaveMethods(actual, declared, Classes.getMethodsWithModifier(actualMethods, Modifier.methodModifiers())));
        }
        if (!Classes.noMissingElement(actualMethodNames, expectedMethodNames, missingMethodNames)) {
            throw this.failures.failure(info, ShouldHaveMethods.shouldHaveMethods(actual, declared, expectedMethodNames, missingMethodNames));
        }
    }

    public void assertHasPublicMethods(AssertionInfo info, Class<?> actual, String ... methods) {
        Classes.assertNotNull(info, actual);
        Method[] actualMethods = actual.getMethods();
        TreeSet<String> expectedMethodNames = Sets.newTreeSet(methods);
        TreeSet<String> missingMethodNames = Sets.newTreeSet();
        Map<String, Integer> methodNamesWithModifier = Classes.methodsToNameAndModifier(actualMethods);
        if (methods.length == 0 && Classes.hasPublicMethods(actualMethods)) {
            throw this.failures.failure(info, ShouldHaveMethods.shouldNotHaveMethods(actual, Modifier.toString(1), false, Classes.getMethodsWithModifier(Sets.newLinkedHashSet(actualMethods), 1)));
        }
        if (!Classes.noMissingElement(methodNamesWithModifier.keySet(), expectedMethodNames, missingMethodNames)) {
            throw this.failures.failure(info, ShouldHaveMethods.shouldHaveMethods(actual, false, expectedMethodNames, missingMethodNames));
        }
        LinkedHashMap<String, String> nonMatchingModifiers = new LinkedHashMap<String, String>();
        if (!Classes.noNonMatchingModifier(expectedMethodNames, methodNamesWithModifier, nonMatchingModifiers, 1)) {
            throw this.failures.failure(info, ShouldHaveMethods.shouldHaveMethods(actual, false, expectedMethodNames, Modifier.toString(1), nonMatchingModifiers));
        }
    }

    private static SortedSet<String> getMethodsWithModifier(Set<Method> methods, int modifier) {
        TreeSet<String> methodsWithModifier = Sets.newTreeSet();
        for (Method method : methods) {
            if ((method.getModifiers() & modifier) == 0) continue;
            methodsWithModifier.add(method.getName());
        }
        return methodsWithModifier;
    }

    private static boolean noNonMatchingModifier(Set<String> expectedMethodNames, Map<String, Integer> methodsModifier, Map<String, String> nonMatchingModifiers, int modifier) {
        for (String method : methodsModifier.keySet()) {
            if (!expectedMethodNames.contains(method) || (methodsModifier.get(method) & modifier) != 0) continue;
            nonMatchingModifiers.put(method, Modifier.toString(methodsModifier.get(method)));
        }
        return nonMatchingModifiers.isEmpty();
    }

    private static boolean hasPublicMethods(Method[] methods) {
        for (Method method : methods) {
            if (!Modifier.isPublic(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static SortedSet<String> methodsToName(Set<Method> methods) {
        TreeSet<String> methodsName = Sets.newTreeSet();
        for (Method method : methods) {
            methodsName.add(method.getName());
        }
        return methodsName;
    }

    private static Map<String, Integer> methodsToNameAndModifier(Method[] methods) {
        LinkedHashMap<String, Integer> methodMap = new LinkedHashMap<String, Integer>(methods.length);
        for (Method method : methods) {
            methodMap.put(method.getName(), method.getModifiers());
        }
        return methodMap;
    }

    private static Method[] getAllMethods(Class<?> actual) {
        LinkedHashSet<Method> allMethods = Sets.newLinkedHashSet();
        Method[] declaredMethods = actual.getDeclaredMethods();
        allMethods.addAll(Sets.newLinkedHashSet(declaredMethods));
        Class<?> superclass = actual.getSuperclass();
        if (superclass != null) {
            allMethods.addAll(Sets.newLinkedHashSet(Classes.getAllMethods(superclass)));
        }
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    private static <M extends Member> Set<M> filterSyntheticMembers(M[] members) {
        LinkedHashSet filteredMembers = Sets.newLinkedHashSet();
        for (M member : members) {
            if (member.isSynthetic()) continue;
            filteredMembers.add(member);
        }
        return filteredMembers;
    }

    private static void assertNotNull(AssertionInfo info, Class<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static void classParameterIsNotNull(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, "The class to compare actual with should not be null");
    }
}

