/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

class HtmxTriggerHeadersRequestCondition
implements RequestCondition<HtmxTriggerHeadersRequestCondition> {
    private static final HtmxTriggerHeadersRequestCondition EMPTY_CONDITION = new HtmxTriggerHeadersRequestCondition();
    private String value;

    public HtmxTriggerHeadersRequestCondition(String value) {
        this.value = value;
    }

    HtmxTriggerHeadersRequestCondition() {
    }

    public HtmxTriggerHeadersRequestCondition combine(HtmxTriggerHeadersRequestCondition other) {
        return other.value != null ? other : this;
    }

    public int compareTo(HtmxTriggerHeadersRequestCondition other, HttpServletRequest request) {
        if (this.value == null && other.value == null) {
            return 0;
        }
        if (this.value == null) {
            return 1;
        }
        if (other.value == null) {
            return -1;
        }
        return this.value.compareTo(other.value);
    }

    public HtmxTriggerHeadersRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (CorsUtils.isPreFlightRequest((HttpServletRequest)request)) {
            return EMPTY_CONDITION;
        }
        String headerValue = request.getHeader(HtmxRequestHeader.HX_TRIGGER.getValue());
        if (headerValue != null && headerValue.equals(this.value)) {
            return this;
        }
        headerValue = request.getHeader(HtmxRequestHeader.HX_TRIGGER_NAME.getValue());
        if (headerValue != null && headerValue.equals(this.value)) {
            return this;
        }
        return null;
    }
}

