// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: envoy/config/core/v3/socket_option.proto

// Protobuf Java Version: 3.25.8
package io.envoyproxy.envoy.config.core.v3;

/**
 * <pre>
 * Generic socket option message. This would be used to set socket options that
 * might not exist in upstream kernels or precompiled Envoy binaries.
 *
 * For example:
 *
 * .. code-block:: json
 *
 *  {
 *    "description": "support tcp keep alive",
 *    "state": 0,
 *    "level": 1,
 *    "name": 9,
 *    "int_value": 1,
 *  }
 *
 * 1 means SOL_SOCKET and 9 means SO_KEEPALIVE on Linux.
 * With the above configuration, `TCP Keep-Alives &lt;https://www.freesoft.org/CIE/RFC/1122/114.htm&gt;`_
 * can be enabled in socket with Linux, which can be used in
 * :ref:`listener's&lt;envoy_v3_api_field_config.listener.v3.Listener.socket_options&gt;` or
 * :ref:`admin's &lt;envoy_v3_api_field_config.bootstrap.v3.Admin.socket_options&gt;` socket_options etc.
 *
 * It should be noted that the name or level may have different values on different platforms.
 * [#next-free-field: 8]
 * </pre>
 *
 * Protobuf type {@code envoy.config.core.v3.SocketOption}
 */
public final class SocketOption extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:envoy.config.core.v3.SocketOption)
    SocketOptionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SocketOption.newBuilder() to construct.
  private SocketOption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SocketOption() {
    description_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new SocketOption();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.envoyproxy.envoy.config.core.v3.SocketOption.class, io.envoyproxy.envoy.config.core.v3.SocketOption.Builder.class);
  }

  /**
   * Protobuf enum {@code envoy.config.core.v3.SocketOption.SocketState}
   */
  public enum SocketState
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Socket options are applied after socket creation but before binding the socket to a port
     * </pre>
     *
     * <code>STATE_PREBIND = 0;</code>
     */
    STATE_PREBIND(0),
    /**
     * <pre>
     * Socket options are applied after binding the socket to a port but before calling listen()
     * </pre>
     *
     * <code>STATE_BOUND = 1;</code>
     */
    STATE_BOUND(1),
    /**
     * <pre>
     * Socket options are applied after calling listen()
     * </pre>
     *
     * <code>STATE_LISTENING = 2;</code>
     */
    STATE_LISTENING(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Socket options are applied after socket creation but before binding the socket to a port
     * </pre>
     *
     * <code>STATE_PREBIND = 0;</code>
     */
    public static final int STATE_PREBIND_VALUE = 0;
    /**
     * <pre>
     * Socket options are applied after binding the socket to a port but before calling listen()
     * </pre>
     *
     * <code>STATE_BOUND = 1;</code>
     */
    public static final int STATE_BOUND_VALUE = 1;
    /**
     * <pre>
     * Socket options are applied after calling listen()
     * </pre>
     *
     * <code>STATE_LISTENING = 2;</code>
     */
    public static final int STATE_LISTENING_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SocketState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SocketState forNumber(int value) {
      switch (value) {
        case 0: return STATE_PREBIND;
        case 1: return STATE_BOUND;
        case 2: return STATE_LISTENING;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SocketState>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SocketState> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SocketState>() {
            public SocketState findValueByNumber(int number) {
              return SocketState.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.core.v3.SocketOption.getDescriptor().getEnumTypes().get(0);
    }

    private static final SocketState[] VALUES = values();

    public static SocketState valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SocketState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:envoy.config.core.v3.SocketOption.SocketState)
  }

  public interface SocketTypeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:envoy.config.core.v3.SocketOption.SocketType)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     * @return Whether the stream field is set.
     */
    boolean hasStream();
    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     * @return The stream.
     */
    io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getStream();
    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     */
    io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder getStreamOrBuilder();

    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     * @return Whether the datagram field is set.
     */
    boolean hasDatagram();
    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     * @return The datagram.
     */
    io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDatagram();
    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     */
    io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder getDatagramOrBuilder();
  }
  /**
   * <pre>
   * The `socket type &lt;https://linux.die.net/man/2/socket&gt;`_ to apply the socket option to.
   * Only one field should be set. If multiple fields are set, the precedence order will determine
   * the selected one. If none of the fields is set, the socket option will be applied to all socket types.
   *
   * For example:
   * If :ref:`stream &lt;envoy_v3_api_field_config.core.v3.SocketOption.SocketType.stream&gt;` is set,
   * it takes precedence over :ref:`datagram &lt;envoy_v3_api_field_config.core.v3.SocketOption.SocketType.datagram&gt;`.
   * </pre>
   *
   * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType}
   */
  public static final class SocketType extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:envoy.config.core.v3.SocketOption.SocketType)
      SocketTypeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SocketType.newBuilder() to construct.
    private SocketType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SocketType() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new SocketType();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder.class);
    }

    public interface StreamOrBuilder extends
        // @@protoc_insertion_point(interface_extends:envoy.config.core.v3.SocketOption.SocketType.Stream)
        com.google.protobuf.MessageOrBuilder {
    }
    /**
     * <pre>
     * The stream socket type.
     * </pre>
     *
     * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType.Stream}
     */
    public static final class Stream extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:envoy.config.core.v3.SocketOption.SocketType.Stream)
        StreamOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Stream.newBuilder() to construct.
      private Stream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Stream() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Stream();
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Stream_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Stream_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder.class);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream)) {
          return super.equals(obj);
        }
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream other = (io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * The stream socket type.
       * </pre>
       *
       * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType.Stream}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:envoy.config.core.v3.SocketOption.SocketType.Stream)
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Stream_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Stream_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder.class);
        }

        // Construct using io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Stream_descriptor;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getDefaultInstanceForType() {
          return io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance();
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream build() {
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream buildPartial() {
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream result = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream) {
            return mergeFrom((io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream other) {
          if (other == io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:envoy.config.core.v3.SocketOption.SocketType.Stream)
      }

      // @@protoc_insertion_point(class_scope:envoy.config.core.v3.SocketOption.SocketType.Stream)
      private static final io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream();
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Stream>
          PARSER = new com.google.protobuf.AbstractParser<Stream>() {
        @java.lang.Override
        public Stream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<Stream> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Stream> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface DatagramOrBuilder extends
        // @@protoc_insertion_point(interface_extends:envoy.config.core.v3.SocketOption.SocketType.Datagram)
        com.google.protobuf.MessageOrBuilder {
    }
    /**
     * <pre>
     * The datagram socket type.
     * </pre>
     *
     * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType.Datagram}
     */
    public static final class Datagram extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:envoy.config.core.v3.SocketOption.SocketType.Datagram)
        DatagramOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Datagram.newBuilder() to construct.
      private Datagram(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Datagram() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Datagram();
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Datagram_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Datagram_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder.class);
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram)) {
          return super.equals(obj);
        }
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram other = (io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram) obj;

        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * The datagram socket type.
       * </pre>
       *
       * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType.Datagram}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:envoy.config.core.v3.SocketOption.SocketType.Datagram)
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Datagram_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Datagram_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder.class);
        }

        // Construct using io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_Datagram_descriptor;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDefaultInstanceForType() {
          return io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance();
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram build() {
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram buildPartial() {
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram result = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram(this);
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram) {
            return mergeFrom((io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram other) {
          if (other == io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance()) return this;
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:envoy.config.core.v3.SocketOption.SocketType.Datagram)
      }

      // @@protoc_insertion_point(class_scope:envoy.config.core.v3.SocketOption.SocketType.Datagram)
      private static final io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram();
      }

      public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Datagram>
          PARSER = new com.google.protobuf.AbstractParser<Datagram>() {
        @java.lang.Override
        public Datagram parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<Datagram> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Datagram> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int STREAM_FIELD_NUMBER = 1;
    private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream stream_;
    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     * @return Whether the stream field is set.
     */
    @java.lang.Override
    public boolean hasStream() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     * @return The stream.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getStream() {
      return stream_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance() : stream_;
    }
    /**
     * <pre>
     * Apply the socket option to the stream socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder getStreamOrBuilder() {
      return stream_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance() : stream_;
    }

    public static final int DATAGRAM_FIELD_NUMBER = 2;
    private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram_;
    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     * @return Whether the datagram field is set.
     */
    @java.lang.Override
    public boolean hasDatagram() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     * @return The datagram.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDatagram() {
      return datagram_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance() : datagram_;
    }
    /**
     * <pre>
     * Apply the socket option to the datagram socket type.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder getDatagramOrBuilder() {
      return datagram_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance() : datagram_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStream());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getDatagram());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getStream());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getDatagram());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType)) {
        return super.equals(obj);
      }
      io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType other = (io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType) obj;

      if (hasStream() != other.hasStream()) return false;
      if (hasStream()) {
        if (!getStream()
            .equals(other.getStream())) return false;
      }
      if (hasDatagram() != other.hasDatagram()) return false;
      if (hasDatagram()) {
        if (!getDatagram()
            .equals(other.getDatagram())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStream()) {
        hash = (37 * hash) + STREAM_FIELD_NUMBER;
        hash = (53 * hash) + getStream().hashCode();
      }
      if (hasDatagram()) {
        hash = (37 * hash) + DATAGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getDatagram().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * The `socket type &lt;https://linux.die.net/man/2/socket&gt;`_ to apply the socket option to.
     * Only one field should be set. If multiple fields are set, the precedence order will determine
     * the selected one. If none of the fields is set, the socket option will be applied to all socket types.
     *
     * For example:
     * If :ref:`stream &lt;envoy_v3_api_field_config.core.v3.SocketOption.SocketType.stream&gt;` is set,
     * it takes precedence over :ref:`datagram &lt;envoy_v3_api_field_config.core.v3.SocketOption.SocketType.datagram&gt;`.
     * </pre>
     *
     * Protobuf type {@code envoy.config.core.v3.SocketOption.SocketType}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:envoy.config.core.v3.SocketOption.SocketType)
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.class, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder.class);
      }

      // Construct using io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getStreamFieldBuilder();
          getDatagramFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        datagram_ = null;
        if (datagramBuilder_ != null) {
          datagramBuilder_.dispose();
          datagramBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_SocketType_descriptor;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType getDefaultInstanceForType() {
        return io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance();
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType build() {
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType buildPartial() {
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType result = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stream_ = streamBuilder_ == null
              ? stream_
              : streamBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.datagram_ = datagramBuilder_ == null
              ? datagram_
              : datagramBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType) {
          return mergeFrom((io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType other) {
        if (other == io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance()) return this;
        if (other.hasStream()) {
          mergeStream(other.getStream());
        }
        if (other.hasDatagram()) {
          mergeDatagram(other.getDatagram());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                input.readMessage(
                    getStreamFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getDatagramFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream stream_;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder> streamBuilder_;
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       * @return Whether the stream field is set.
       */
      public boolean hasStream() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       * @return The stream.
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream getStream() {
        if (streamBuilder_ == null) {
          return stream_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance() : stream_;
        } else {
          return streamBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public Builder setStream(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream value) {
        if (streamBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stream_ = value;
        } else {
          streamBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public Builder setStream(
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder builderForValue) {
        if (streamBuilder_ == null) {
          stream_ = builderForValue.build();
        } else {
          streamBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public Builder mergeStream(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream value) {
        if (streamBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
            stream_ != null &&
            stream_ != io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance()) {
            getStreamBuilder().mergeFrom(value);
          } else {
            stream_ = value;
          }
        } else {
          streamBuilder_.mergeFrom(value);
        }
        if (stream_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public Builder clearStream() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stream_ = null;
        if (streamBuilder_ != null) {
          streamBuilder_.dispose();
          streamBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder getStreamBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStreamFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder getStreamOrBuilder() {
        if (streamBuilder_ != null) {
          return streamBuilder_.getMessageOrBuilder();
        } else {
          return stream_ == null ?
              io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.getDefaultInstance() : stream_;
        }
      }
      /**
       * <pre>
       * Apply the socket option to the stream socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Stream stream = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder> 
          getStreamFieldBuilder() {
        if (streamBuilder_ == null) {
          streamBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Stream.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.StreamOrBuilder>(
                  getStream(),
                  getParentForChildren(),
                  isClean());
          stream_ = null;
        }
        return streamBuilder_;
      }

      private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram_;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder> datagramBuilder_;
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       * @return Whether the datagram field is set.
       */
      public boolean hasDatagram() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       * @return The datagram.
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram getDatagram() {
        if (datagramBuilder_ == null) {
          return datagram_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance() : datagram_;
        } else {
          return datagramBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public Builder setDatagram(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram value) {
        if (datagramBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          datagram_ = value;
        } else {
          datagramBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public Builder setDatagram(
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder builderForValue) {
        if (datagramBuilder_ == null) {
          datagram_ = builderForValue.build();
        } else {
          datagramBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public Builder mergeDatagram(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram value) {
        if (datagramBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            datagram_ != null &&
            datagram_ != io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance()) {
            getDatagramBuilder().mergeFrom(value);
          } else {
            datagram_ = value;
          }
        } else {
          datagramBuilder_.mergeFrom(value);
        }
        if (datagram_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public Builder clearDatagram() {
        bitField0_ = (bitField0_ & ~0x00000002);
        datagram_ = null;
        if (datagramBuilder_ != null) {
          datagramBuilder_.dispose();
          datagramBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder getDatagramBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDatagramFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder getDatagramOrBuilder() {
        if (datagramBuilder_ != null) {
          return datagramBuilder_.getMessageOrBuilder();
        } else {
          return datagram_ == null ?
              io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.getDefaultInstance() : datagram_;
        }
      }
      /**
       * <pre>
       * Apply the socket option to the datagram socket type.
       * </pre>
       *
       * <code>.envoy.config.core.v3.SocketOption.SocketType.Datagram datagram = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder> 
          getDatagramFieldBuilder() {
        if (datagramBuilder_ == null) {
          datagramBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Datagram.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.DatagramOrBuilder>(
                  getDatagram(),
                  getParentForChildren(),
                  isClean());
          datagram_ = null;
        }
        return datagramBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:envoy.config.core.v3.SocketOption.SocketType)
    }

    // @@protoc_insertion_point(class_scope:envoy.config.core.v3.SocketOption.SocketType)
    private static final io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType();
    }

    public static io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SocketType>
        PARSER = new com.google.protobuf.AbstractParser<SocketType>() {
      @java.lang.Override
      public SocketType parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SocketType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SocketType> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int bitField0_;
  private int valueCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object value_;
  public enum ValueCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INT_VALUE(4),
    BUF_VALUE(5),
    VALUE_NOT_SET(0);
    private final int value;
    private ValueCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueCase forNumber(int value) {
      switch (value) {
        case 4: return INT_VALUE;
        case 5: return BUF_VALUE;
        case 0: return VALUE_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ValueCase
  getValueCase() {
    return ValueCase.forNumber(
        valueCase_);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <pre>
   * An optional name to give this socket option for debugging, etc.
   * Uniqueness is not required and no special meaning is assumed.
   * </pre>
   *
   * <code>string description = 1;</code>
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * An optional name to give this socket option for debugging, etc.
   * Uniqueness is not required and no special meaning is assumed.
   * </pre>
   *
   * <code>string description = 1;</code>
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LEVEL_FIELD_NUMBER = 2;
  private long level_ = 0L;
  /**
   * <pre>
   * Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
   * </pre>
   *
   * <code>int64 level = 2;</code>
   * @return The level.
   */
  @java.lang.Override
  public long getLevel() {
    return level_;
  }

  public static final int NAME_FIELD_NUMBER = 3;
  private long name_ = 0L;
  /**
   * <pre>
   * The numeric name as passed to setsockopt
   * </pre>
   *
   * <code>int64 name = 3;</code>
   * @return The name.
   */
  @java.lang.Override
  public long getName() {
    return name_;
  }

  public static final int INT_VALUE_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Because many sockopts take an int value.
   * </pre>
   *
   * <code>int64 int_value = 4;</code>
   * @return Whether the intValue field is set.
   */
  @java.lang.Override
  public boolean hasIntValue() {
    return valueCase_ == 4;
  }
  /**
   * <pre>
   * Because many sockopts take an int value.
   * </pre>
   *
   * <code>int64 int_value = 4;</code>
   * @return The intValue.
   */
  @java.lang.Override
  public long getIntValue() {
    if (valueCase_ == 4) {
      return (java.lang.Long) value_;
    }
    return 0L;
  }

  public static final int BUF_VALUE_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Otherwise it's a byte buffer.
   * </pre>
   *
   * <code>bytes buf_value = 5;</code>
   * @return Whether the bufValue field is set.
   */
  @java.lang.Override
  public boolean hasBufValue() {
    return valueCase_ == 5;
  }
  /**
   * <pre>
   * Otherwise it's a byte buffer.
   * </pre>
   *
   * <code>bytes buf_value = 5;</code>
   * @return The bufValue.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBufValue() {
    if (valueCase_ == 5) {
      return (com.google.protobuf.ByteString) value_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   * <pre>
   * The state in which the option will be applied. When used in BindConfig
   * STATE_PREBIND is currently the only valid value.
   * </pre>
   *
   * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override public int getStateValue() {
    return state_;
  }
  /**
   * <pre>
   * The state in which the option will be applied. When used in BindConfig
   * STATE_PREBIND is currently the only valid value.
   * </pre>
   *
   * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
   * @return The state.
   */
  @java.lang.Override public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState getState() {
    io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState result = io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.forNumber(state_);
    return result == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.UNRECOGNIZED : result;
  }

  public static final int TYPE_FIELD_NUMBER = 7;
  private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType type_;
  /**
   * <pre>
   * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
   * If not specified, the socket option will be applied to all socket types.
   * </pre>
   *
   * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
   * If not specified, the socket option will be applied to all socket types.
   * </pre>
   *
   * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
   * @return The type.
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType getType() {
    return type_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance() : type_;
  }
  /**
   * <pre>
   * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
   * If not specified, the socket option will be applied to all socket types.
   * </pre>
   *
   * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
   */
  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder getTypeOrBuilder() {
    return type_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance() : type_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    if (level_ != 0L) {
      output.writeInt64(2, level_);
    }
    if (name_ != 0L) {
      output.writeInt64(3, name_);
    }
    if (valueCase_ == 4) {
      output.writeInt64(
          4, (long)((java.lang.Long) value_));
    }
    if (valueCase_ == 5) {
      output.writeBytes(
          5, (com.google.protobuf.ByteString) value_);
    }
    if (state_ != io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.STATE_PREBIND.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getType());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    if (level_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(2, level_);
    }
    if (name_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, name_);
    }
    if (valueCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(
            4, (long)((java.lang.Long) value_));
    }
    if (valueCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(
            5, (com.google.protobuf.ByteString) value_);
    }
    if (state_ != io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.STATE_PREBIND.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getType());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.envoyproxy.envoy.config.core.v3.SocketOption)) {
      return super.equals(obj);
    }
    io.envoyproxy.envoy.config.core.v3.SocketOption other = (io.envoyproxy.envoy.config.core.v3.SocketOption) obj;

    if (!getDescription()
        .equals(other.getDescription())) return false;
    if (getLevel()
        != other.getLevel()) return false;
    if (getName()
        != other.getName()) return false;
    if (state_ != other.state_) return false;
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType()
          .equals(other.getType())) return false;
    }
    if (!getValueCase().equals(other.getValueCase())) return false;
    switch (valueCase_) {
      case 4:
        if (getIntValue()
            != other.getIntValue()) return false;
        break;
      case 5:
        if (!getBufValue()
            .equals(other.getBufValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getLevel());
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getName());
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    switch (valueCase_) {
      case 4:
        hash = (37 * hash) + INT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getIntValue());
        break;
      case 5:
        hash = (37 * hash) + BUF_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getBufValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.envoyproxy.envoy.config.core.v3.SocketOption parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.envoyproxy.envoy.config.core.v3.SocketOption prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Generic socket option message. This would be used to set socket options that
   * might not exist in upstream kernels or precompiled Envoy binaries.
   *
   * For example:
   *
   * .. code-block:: json
   *
   *  {
   *    "description": "support tcp keep alive",
   *    "state": 0,
   *    "level": 1,
   *    "name": 9,
   *    "int_value": 1,
   *  }
   *
   * 1 means SOL_SOCKET and 9 means SO_KEEPALIVE on Linux.
   * With the above configuration, `TCP Keep-Alives &lt;https://www.freesoft.org/CIE/RFC/1122/114.htm&gt;`_
   * can be enabled in socket with Linux, which can be used in
   * :ref:`listener's&lt;envoy_v3_api_field_config.listener.v3.Listener.socket_options&gt;` or
   * :ref:`admin's &lt;envoy_v3_api_field_config.bootstrap.v3.Admin.socket_options&gt;` socket_options etc.
   *
   * It should be noted that the name or level may have different values on different platforms.
   * [#next-free-field: 8]
   * </pre>
   *
   * Protobuf type {@code envoy.config.core.v3.SocketOption}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:envoy.config.core.v3.SocketOption)
      io.envoyproxy.envoy.config.core.v3.SocketOptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.envoyproxy.envoy.config.core.v3.SocketOption.class, io.envoyproxy.envoy.config.core.v3.SocketOption.Builder.class);
    }

    // Construct using io.envoyproxy.envoy.config.core.v3.SocketOption.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getTypeFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      level_ = 0L;
      name_ = 0L;
      state_ = 0;
      type_ = null;
      if (typeBuilder_ != null) {
        typeBuilder_.dispose();
        typeBuilder_ = null;
      }
      valueCase_ = 0;
      value_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.envoyproxy.envoy.config.core.v3.SocketOptionProto.internal_static_envoy_config_core_v3_SocketOption_descriptor;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption getDefaultInstanceForType() {
      return io.envoyproxy.envoy.config.core.v3.SocketOption.getDefaultInstance();
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption build() {
      io.envoyproxy.envoy.config.core.v3.SocketOption result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption buildPartial() {
      io.envoyproxy.envoy.config.core.v3.SocketOption result = new io.envoyproxy.envoy.config.core.v3.SocketOption(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(io.envoyproxy.envoy.config.core.v3.SocketOption result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.level_ = level_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.type_ = typeBuilder_ == null
            ? type_
            : typeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(io.envoyproxy.envoy.config.core.v3.SocketOption result) {
      result.valueCase_ = valueCase_;
      result.value_ = this.value_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.envoyproxy.envoy.config.core.v3.SocketOption) {
        return mergeFrom((io.envoyproxy.envoy.config.core.v3.SocketOption)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.envoyproxy.envoy.config.core.v3.SocketOption other) {
      if (other == io.envoyproxy.envoy.config.core.v3.SocketOption.getDefaultInstance()) return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getLevel() != 0L) {
        setLevel(other.getLevel());
      }
      if (other.getName() != 0L) {
        setName(other.getName());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasType()) {
        mergeType(other.getType());
      }
      switch (other.getValueCase()) {
        case INT_VALUE: {
          setIntValue(other.getIntValue());
          break;
        }
        case BUF_VALUE: {
          setBufValue(other.getBufValue());
          break;
        }
        case VALUE_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              description_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 16: {
              level_ = input.readInt64();
              bitField0_ |= 0x00000002;
              break;
            } // case 16
            case 24: {
              name_ = input.readInt64();
              bitField0_ |= 0x00000004;
              break;
            } // case 24
            case 32: {
              value_ = input.readInt64();
              valueCase_ = 4;
              break;
            } // case 32
            case 42: {
              value_ = input.readBytes();
              valueCase_ = 5;
              break;
            } // case 42
            case 48: {
              state_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 48
            case 58: {
              input.readMessage(
                  getTypeFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000040;
              break;
            } // case 58
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int valueCase_ = 0;
    private java.lang.Object value_;
    public ValueCase
        getValueCase() {
      return ValueCase.forNumber(
          valueCase_);
    }

    public Builder clearValue() {
      valueCase_ = 0;
      value_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * An optional name to give this socket option for debugging, etc.
     * Uniqueness is not required and no special meaning is assumed.
     * </pre>
     *
     * <code>string description = 1;</code>
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * An optional name to give this socket option for debugging, etc.
     * Uniqueness is not required and no special meaning is assumed.
     * </pre>
     *
     * <code>string description = 1;</code>
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * An optional name to give this socket option for debugging, etc.
     * Uniqueness is not required and no special meaning is assumed.
     * </pre>
     *
     * <code>string description = 1;</code>
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * An optional name to give this socket option for debugging, etc.
     * Uniqueness is not required and no special meaning is assumed.
     * </pre>
     *
     * <code>string description = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * An optional name to give this socket option for debugging, etc.
     * Uniqueness is not required and no special meaning is assumed.
     * </pre>
     *
     * <code>string description = 1;</code>
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long level_ ;
    /**
     * <pre>
     * Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
     * </pre>
     *
     * <code>int64 level = 2;</code>
     * @return The level.
     */
    @java.lang.Override
    public long getLevel() {
      return level_;
    }
    /**
     * <pre>
     * Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
     * </pre>
     *
     * <code>int64 level = 2;</code>
     * @param value The level to set.
     * @return This builder for chaining.
     */
    public Builder setLevel(long value) {

      level_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Corresponding to the level value passed to setsockopt, such as IPPROTO_TCP
     * </pre>
     *
     * <code>int64 level = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearLevel() {
      bitField0_ = (bitField0_ & ~0x00000002);
      level_ = 0L;
      onChanged();
      return this;
    }

    private long name_ ;
    /**
     * <pre>
     * The numeric name as passed to setsockopt
     * </pre>
     *
     * <code>int64 name = 3;</code>
     * @return The name.
     */
    @java.lang.Override
    public long getName() {
      return name_;
    }
    /**
     * <pre>
     * The numeric name as passed to setsockopt
     * </pre>
     *
     * <code>int64 name = 3;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(long value) {

      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The numeric name as passed to setsockopt
     * </pre>
     *
     * <code>int64 name = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      bitField0_ = (bitField0_ & ~0x00000004);
      name_ = 0L;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Because many sockopts take an int value.
     * </pre>
     *
     * <code>int64 int_value = 4;</code>
     * @return Whether the intValue field is set.
     */
    public boolean hasIntValue() {
      return valueCase_ == 4;
    }
    /**
     * <pre>
     * Because many sockopts take an int value.
     * </pre>
     *
     * <code>int64 int_value = 4;</code>
     * @return The intValue.
     */
    public long getIntValue() {
      if (valueCase_ == 4) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }
    /**
     * <pre>
     * Because many sockopts take an int value.
     * </pre>
     *
     * <code>int64 int_value = 4;</code>
     * @param value The intValue to set.
     * @return This builder for chaining.
     */
    public Builder setIntValue(long value) {

      valueCase_ = 4;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Because many sockopts take an int value.
     * </pre>
     *
     * <code>int64 int_value = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearIntValue() {
      if (valueCase_ == 4) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    /**
     * <pre>
     * Otherwise it's a byte buffer.
     * </pre>
     *
     * <code>bytes buf_value = 5;</code>
     * @return Whether the bufValue field is set.
     */
    public boolean hasBufValue() {
      return valueCase_ == 5;
    }
    /**
     * <pre>
     * Otherwise it's a byte buffer.
     * </pre>
     *
     * <code>bytes buf_value = 5;</code>
     * @return The bufValue.
     */
    public com.google.protobuf.ByteString getBufValue() {
      if (valueCase_ == 5) {
        return (com.google.protobuf.ByteString) value_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     * <pre>
     * Otherwise it's a byte buffer.
     * </pre>
     *
     * <code>bytes buf_value = 5;</code>
     * @param value The bufValue to set.
     * @return This builder for chaining.
     */
    public Builder setBufValue(com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      valueCase_ = 5;
      value_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Otherwise it's a byte buffer.
     * </pre>
     *
     * <code>bytes buf_value = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearBufValue() {
      if (valueCase_ == 5) {
        valueCase_ = 0;
        value_ = null;
        onChanged();
      }
      return this;
    }

    private int state_ = 0;
    /**
     * <pre>
     * The state in which the option will be applied. When used in BindConfig
     * STATE_PREBIND is currently the only valid value.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override public int getStateValue() {
      return state_;
    }
    /**
     * <pre>
     * The state in which the option will be applied. When used in BindConfig
     * STATE_PREBIND is currently the only valid value.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The state in which the option will be applied. When used in BindConfig
     * STATE_PREBIND is currently the only valid value.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
     * @return The state.
     */
    @java.lang.Override
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState getState() {
      io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState result = io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.forNumber(state_);
      return result == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The state in which the option will be applied. When used in BindConfig
     * STATE_PREBIND is currently the only valid value.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The state in which the option will be applied. When used in BindConfig
     * STATE_PREBIND is currently the only valid value.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketState state = 6 [(.validate.rules) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType type_;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder> typeBuilder_;
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     * @return The type.
     */
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType getType() {
      if (typeBuilder_ == null) {
        return type_ == null ? io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance() : type_;
      } else {
        return typeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public Builder setType(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType value) {
      if (typeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
      } else {
        typeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public Builder setType(
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder builderForValue) {
      if (typeBuilder_ == null) {
        type_ = builderForValue.build();
      } else {
        typeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public Builder mergeType(io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType value) {
      if (typeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0) &&
          type_ != null &&
          type_ != io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance()) {
          getTypeBuilder().mergeFrom(value);
        } else {
          type_ = value;
        }
      } else {
        typeBuilder_.mergeFrom(value);
      }
      if (type_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      type_ = null;
      if (typeBuilder_ != null) {
        typeBuilder_.dispose();
        typeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder getTypeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTypeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    public io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder getTypeOrBuilder() {
      if (typeBuilder_ != null) {
        return typeBuilder_.getMessageOrBuilder();
      } else {
        return type_ == null ?
            io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.getDefaultInstance() : type_;
      }
    }
    /**
     * <pre>
     * Apply the socket option to the specified `socket type &lt;https://linux.die.net/man/2/socket&gt;`_.
     * If not specified, the socket option will be applied to all socket types.
     * </pre>
     *
     * <code>.envoy.config.core.v3.SocketOption.SocketType type = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder> 
        getTypeFieldBuilder() {
      if (typeBuilder_ == null) {
        typeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketType.Builder, io.envoyproxy.envoy.config.core.v3.SocketOption.SocketTypeOrBuilder>(
                getType(),
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      return typeBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:envoy.config.core.v3.SocketOption)
  }

  // @@protoc_insertion_point(class_scope:envoy.config.core.v3.SocketOption)
  private static final io.envoyproxy.envoy.config.core.v3.SocketOption DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.envoyproxy.envoy.config.core.v3.SocketOption();
  }

  public static io.envoyproxy.envoy.config.core.v3.SocketOption getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SocketOption>
      PARSER = new com.google.protobuf.AbstractParser<SocketOption>() {
    @java.lang.Override
    public SocketOption parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<SocketOption> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SocketOption> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.envoyproxy.envoy.config.core.v3.SocketOption getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

