/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.internal;

import io.lettuce.core.RedisBusyException;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisCommandTimeoutException;
import io.lettuce.core.RedisLoadingException;
import io.lettuce.core.RedisNoScriptException;
import io.lettuce.core.RedisReadOnlyException;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public abstract class ExceptionFactory {
    private static final DateTimeFormatter MINUTES = new DateTimeFormatterBuilder().appendText(ChronoField.MINUTE_OF_DAY).appendLiteral(" minute(s)").toFormatter();
    private static final DateTimeFormatter SECONDS = new DateTimeFormatterBuilder().appendText(ChronoField.SECOND_OF_DAY).appendLiteral(" second(s)").toFormatter();
    private static final DateTimeFormatter MILLISECONDS = new DateTimeFormatterBuilder().appendText(ChronoField.MILLI_OF_DAY).appendLiteral(" millisecond(s)").toFormatter();

    private ExceptionFactory() {
    }

    public static RedisCommandTimeoutException createTimeoutException(Duration timeout) {
        return new RedisCommandTimeoutException(String.format("Command timed out after %s", ExceptionFactory.formatTimeout(timeout)));
    }

    public static RedisCommandTimeoutException createTimeoutException(String message, Duration timeout) {
        return new RedisCommandTimeoutException(String.format("%s. Command timed out after %s", message, ExceptionFactory.formatTimeout(timeout)));
    }

    public static String formatTimeout(Duration duration) {
        if (duration.isZero()) {
            return "no timeout";
        }
        LocalTime time = LocalTime.MIDNIGHT.plus(duration);
        if (ExceptionFactory.isExactMinutes(duration)) {
            return MINUTES.format(time);
        }
        if (ExceptionFactory.isExactSeconds(duration)) {
            return SECONDS.format(time);
        }
        if (ExceptionFactory.isExactMillis(duration)) {
            return MILLISECONDS.format(time);
        }
        return String.format("%d ns", duration.toNanos());
    }

    private static boolean isExactMinutes(Duration duration) {
        return duration.toMillis() % 60000L == 0L && duration.getNano() == 0;
    }

    private static boolean isExactSeconds(Duration duration) {
        return duration.toMillis() % 1000L == 0L && duration.getNano() == 0;
    }

    private static boolean isExactMillis(Duration duration) {
        return duration.toNanos() % 1000000L == 0L;
    }

    public static RedisCommandExecutionException createExecutionException(String message) {
        return ExceptionFactory.createExecutionException(message, null);
    }

    public static RedisCommandExecutionException createExecutionException(String message, Throwable cause) {
        if (message != null) {
            if (message.startsWith("BUSY")) {
                return cause != null ? new RedisBusyException(message, cause) : new RedisBusyException(message);
            }
            if (message.startsWith("NOSCRIPT")) {
                return cause != null ? new RedisNoScriptException(message, cause) : new RedisNoScriptException(message);
            }
            if (message.startsWith("LOADING")) {
                return cause != null ? new RedisLoadingException(message, cause) : new RedisLoadingException(message);
            }
            if (message.startsWith("READONLY")) {
                return cause != null ? new RedisReadOnlyException(message, cause) : new RedisReadOnlyException(message);
            }
            return cause != null ? new RedisCommandExecutionException(message, cause) : new RedisCommandExecutionException(message);
        }
        return new RedisCommandExecutionException(cause);
    }
}

