/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterreplica;

import io.lettuce.core.RedisFuture;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.internal.Exceptions;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.masterreplica.RedisMasterReplicaNode;
import io.lettuce.core.masterreplica.TopologyProvider;
import io.lettuce.core.models.role.RedisInstance;
import io.lettuce.core.models.role.RedisNodeDescription;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Mono;

class ReplicaTopologyProvider
implements TopologyProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReplicaTopologyProvider.class);
    private final StatefulRedisConnection<?, ?> connection;
    private final RedisURI redisURI;

    public ReplicaTopologyProvider(StatefulRedisConnection<?, ?> connection, RedisURI redisURI) {
        LettuceAssert.notNull(connection, "Redis Connection must not be null");
        LettuceAssert.notNull((Object)redisURI, "RedisURI must not be null");
        this.connection = connection;
        this.redisURI = redisURI;
    }

    @Override
    public List<RedisNodeDescription> getNodes() {
        logger.debug("Performing topology lookup");
        String info2 = this.connection.sync().info("replication");
        try {
            return this.getNodesFromInfo(info2);
        }
        catch (RuntimeException e) {
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public CompletableFuture<List<RedisNodeDescription>> getNodesAsync() {
        logger.debug("Performing topology lookup");
        RedisFuture<String> info2 = this.connection.async().info("replication");
        try {
            return Mono.fromCompletionStage(info2).timeout(this.redisURI.getTimeout()).map(this::getNodesFromInfo).toFuture();
        }
        catch (RuntimeException e) {
            throw Exceptions.bubble(e);
        }
    }

    protected List<RedisNodeDescription> getNodesFromInfo(String info2) {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        RedisNodeDescription currentNodeDescription = this.getCurrentNodeDescription(info2);
        result.add(currentNodeDescription);
        if (currentNodeDescription.getRole().isUpstream()) {
            result.addAll(this.getReplicasFromInfo(info2));
        } else {
            result.add(this.getMasterFromInfo(info2));
        }
        return result;
    }

    private RedisNodeDescription getCurrentNodeDescription(String info2) {
        Matcher matcher = InfoPatterns.ROLE.matcher(info2);
        if (!matcher.find()) {
            throw new IllegalStateException("No role property in info " + info2);
        }
        return this.getRedisNodeDescription(matcher);
    }

    private List<RedisNodeDescription> getReplicasFromInfo(String info2) {
        ArrayList<RedisNodeDescription> replicas = new ArrayList<RedisNodeDescription>();
        Matcher matcher = InfoPatterns.SLAVE.matcher(info2);
        while (matcher.find()) {
            String group = matcher.group(2);
            String ip = this.getNested(InfoPatterns.IP, group, 1);
            String port = this.getNested(InfoPatterns.PORT, group, 1);
            replicas.add(new RedisMasterReplicaNode(ip, Integer.parseInt(port), this.redisURI, RedisInstance.Role.SLAVE));
        }
        return replicas;
    }

    private RedisNodeDescription getMasterFromInfo(String info2) {
        Matcher masterHostMatcher = InfoPatterns.MASTER_HOST.matcher(info2);
        Matcher masterPortMatcher = InfoPatterns.MASTER_PORT.matcher(info2);
        boolean foundHost = masterHostMatcher.find();
        boolean foundPort = masterPortMatcher.find();
        if (!foundHost || !foundPort) {
            throw new IllegalStateException("Cannot resolve master from info " + info2);
        }
        String host = masterHostMatcher.group(1);
        int port = Integer.parseInt(masterPortMatcher.group(1));
        return new RedisMasterReplicaNode(host, port, this.redisURI, RedisInstance.Role.UPSTREAM);
    }

    private String getNested(InfoPatterns pattern, String string, int group) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(group);
        }
        throw new IllegalArgumentException("Cannot extract group " + group + " with pattern " + pattern.getPattern() + " from " + string);
    }

    private RedisNodeDescription getRedisNodeDescription(Matcher matcher) {
        String roleString = matcher.group(1);
        RedisInstance.Role role = null;
        if (RedisInstance.Role.MASTER.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.UPSTREAM;
        }
        if (RedisInstance.Role.SLAVE.name().equalsIgnoreCase(roleString) | RedisInstance.Role.REPLICA.name().equalsIgnoreCase(roleString)) {
            role = RedisInstance.Role.REPLICA;
        }
        if (role == null) {
            throw new IllegalStateException("Cannot resolve role " + roleString + " to " + (Object)((Object)RedisInstance.Role.UPSTREAM) + " or " + (Object)((Object)RedisInstance.Role.REPLICA));
        }
        return new RedisMasterReplicaNode(this.redisURI.getHost(), this.redisURI.getPort(), this.redisURI, role);
    }

    static enum InfoPatterns {
        ROLE(Pattern.compile("^role\\:([a-z]+)$", 8)),
        SLAVE(Pattern.compile("^slave(\\d+)\\:([a-zA-Z\\,\\=\\d\\.\\:\\-]+)$", 8)),
        MASTER_HOST(Pattern.compile("^master_host\\:([a-zA-Z\\,\\=\\d\\.\\:\\-]+)$", 8)),
        MASTER_PORT(Pattern.compile("^master_port\\:(\\d+)$", 8)),
        IP(Pattern.compile("ip\\=([a-zA-Z\\d\\.\\:\\-]+)")),
        PORT(Pattern.compile("port\\=([\\d]+)"));

        private final Pattern pattern;

        private InfoPatterns(Pattern pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public Matcher matcher(String input) {
            return this.pattern.matcher(input);
        }
    }
}

