/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.StreamUtils;
import io.milton.http.Range;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeUtils {
    private static final Logger log = LoggerFactory.getLogger(RangeUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRanges(InputStream in, List<Range> ranges, OutputStream responseOut) throws IOException {
        try {
            InputStream bufIn = in;
            long pos = 0L;
            for (Range r : ranges) {
                long skip = r.getStart() - pos;
                bufIn.skip(skip);
                long length = r.getFinish() - r.getStart();
                RangeUtils.sendBytes(bufIn, responseOut, length);
                pos = r.getFinish();
            }
        }
        finally {
            StreamUtils.close(in);
        }
    }

    public static void sendBytes(InputStream in, OutputStream out, long length) throws IOException {
        long remainingBytes;
        int maxLength;
        int s;
        log.trace("sendBytes: " + length);
        byte[] b = new byte[1024];
        for (long numRead = 0L; numRead < length && (s = in.read(b, 0, maxLength = (remainingBytes = length - numRead) > 1024L ? 1024 : (int)remainingBytes)) >= 0; numRead += (long)s) {
            out.write(b, 0, s);
        }
    }

    public static void writeRange(InputStream in, Range r, OutputStream responseOut) throws IOException {
        long skip = r.getStart();
        in.skip(skip);
        long length = r.getFinish() - r.getStart();
        RangeUtils.sendBytes(in, responseOut, length);
    }
}

