/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.ReadingException;
import io.milton.common.WritingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static Logger log = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    private static void skip(InputStream in, Long start) {
        try {
            in.skip(start);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long readTo(File inFile, OutputStream out, boolean closeOut) throws ReadingException, WritingException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(inFile);
            long l = StreamUtils.readTo(in, out);
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                log.error("exception closing output stream", (Throwable)ex);
            }
            if (closeOut) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    log.error("exception closing outputstream", (Throwable)ex);
                }
            }
        }
    }

    public static long readTo(InputStream in, File outFile, boolean closeIn) throws ReadingException, WritingException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outFile);
            long l = StreamUtils.readTo(in, out);
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                log.error("exception closing output stream", (Throwable)ex);
            }
            if (closeIn) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error("exception closing inputstream", (Throwable)ex);
                }
            }
        }
    }

    public static long readTo(InputStream in, OutputStream out) throws ReadingException, WritingException {
        return StreamUtils.readTo(in, out, false, false, null, null);
    }

    public static long readTo(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws ReadingException, WritingException {
        return StreamUtils.readTo(in, out, closeIn, closeOut, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readTo(InputStream in, OutputStream out, boolean closeIn, boolean closeOut, Long start, Long finish) throws ReadingException, WritingException {
        long cnt = 0L;
        if (start != null) {
            StreamUtils.skip(in, start);
            cnt = start;
        }
        byte[] buf = new byte[1024];
        try {
            int s;
            try {
                s = in.read(buf);
            }
            catch (IOException ex) {
                throw new ReadingException(ex);
            }
            catch (NullPointerException e) {
                log.debug("nullpointer exception reading input stream. it happens for sun.nio.ch.ChannelInputStream.read(ChannelInputStream.java:48)");
                long l = cnt;
                if (closeIn) {
                    StreamUtils.close(in);
                }
                if (closeOut) {
                    StreamUtils.close(out);
                }
                return l;
            }
            long numBytes = 0L;
            while (s > 0) {
                try {
                    numBytes += (long)s;
                    out.write(buf, 0, s);
                    if ((cnt += (long)s) > 10000L) {
                        out.flush();
                        cnt = 0L;
                    }
                }
                catch (IOException ex) {
                    throw new WritingException(ex);
                }
                try {
                    s = in.read(buf);
                }
                catch (IOException ex) {
                    throw new ReadingException(ex);
                }
            }
            try {
                out.flush();
            }
            catch (IOException ex) {
                throw new WritingException(ex);
            }
            long l = numBytes;
            return l;
        }
        finally {
            if (closeIn) {
                StreamUtils.close(in);
            }
            if (closeOut) {
                StreamUtils.close(out);
            }
        }
    }

    public static void close(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            log.warn("exception closing output stream", (Throwable)ex);
        }
    }

    public static void close(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            log.warn("exception closing inputstream", (Throwable)ex);
        }
    }
}

