/*
 * Decompiled with CFR 0.152.
 */
package io.milton.context;

import io.milton.context.Context;
import io.milton.context.Executable;
import io.milton.context.Executable2;
import io.milton.context.Factory;
import io.milton.context.FactoryCatalog;
import io.milton.context.Registration;
import io.milton.context.RequestContext;
import io.milton.context.RootContextLocator;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootContext
extends Context
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RootContext.class);
    private final FactoryCatalog factoryCatalog;

    public RootContext() {
        this.factoryCatalog = new FactoryCatalog();
    }

    public RootContext(FactoryCatalog factoryCatalog) {
        this(factoryCatalog, null);
    }

    public RootContext(FactoryCatalog factoryCatalog, List<Object> initialContents) {
        if (factoryCatalog == null) {
            throw new IllegalArgumentException("factoryCatalog cannot be null");
        }
        this.factoryCatalog = factoryCatalog;
        this.put("configFile", factoryCatalog.getConfigFile());
        try {
            if (initialContents != null) {
                for (Object object : initialContents) {
                    this.put(object);
                }
            }
            for (Map.Entry entry : factoryCatalog.keys.entrySet()) {
                this.put((String)entry.getKey(), entry.getValue());
            }
            for (Factory factory : factoryCatalog.factories) {
                factory.init(this);
            }
        }
        catch (Throwable e) {
            System.out.println("Exception initialising the rootcontext. Forcing shutdown");
            e.printStackTrace();
            log.error("Exception initialising the rootcontext. Forcing shutdown", e);
            try {
                this.shutdown();
            }
            catch (Throwable throwable) {
                log.error("Failed to shutdown properly", throwable);
            }
            throw new RuntimeException(e);
        }
    }

    public void put(Object ... beans) {
        for (Object o : beans) {
            this.put(o);
        }
    }

    public void execute(Executable2 exec) {
        RequestContext.setCurrent(null);
        RequestContext context = RequestContext.getInstance(this);
        Registration<Executable2> reg = null;
        try {
            reg = context.put(exec, context);
            exec.execute(context);
        }
        catch (Throwable e) {
            log.error("error executing: " + exec, e);
            throw new RuntimeException(e);
        }
        finally {
            reg.remove();
            context.tearDown();
            RequestContext.setCurrent(null);
        }
    }

    public <T> T execute(Executable<T> exec) {
        RequestContext context = RequestContext.getInstance(this);
        Registration<Executable<T>> reg = null;
        try {
            T t;
            reg = context.put(exec, context);
            T t2 = t = exec.execute(context);
            return t2;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            reg.remove();
            if (RequestContext.peekInstance() != null) {
                throw new RuntimeException("Did not close down properly");
            }
            context.tearDown();
        }
    }

    protected Registration getRegistration(Class c) throws IllegalArgumentException {
        return this.getOrCreateRegistration(c, (Context)this);
    }

    protected Registration getRegistration(String id) {
        return this.getOrCreateRegistration(id, (Context)this);
    }

    @Override
    Registration getOrCreateRegistration(Class c, Context context) {
        Registration reg = super.getRegistration(c);
        if (reg != null) {
            return reg;
        }
        Factory f = this.factoryCatalog.get(c);
        if (f == null) {
            return null;
        }
        reg = f.insert(this, context);
        if (reg == null) {
            throw new NullPointerException("factory " + f.getClass().getName() + " returned null reg");
        }
        return reg;
    }

    @Override
    Registration getOrCreateRegistration(String id, Context context) {
        Registration reg = super.getRegistration(id);
        if (reg != null) {
            return reg;
        }
        Factory f = this.factoryCatalog.get(id);
        if (f == null) {
            return null;
        }
        return f.insert(this, context);
    }

    public void shutdown() {
        Object[] items;
        log.warn("shutdown");
        for (Object o : items = this.itemByClass.values().toArray()) {
            Registration r = (Registration)o;
            try {
                log.debug("remove: " + r.item.getClass());
                r.remove();
            }
            catch (Throwable e) {
                log.error("Failed to do remove on registration: " + r);
            }
        }
        for (Factory f : this.factoryCatalog.factories) {
            log.warn("destroy: " + f.getClass());
            try {
                f.destroy();
            }
            catch (Throwable e) {
                log.error("Failed to do destroy on factory: " + f);
            }
        }
    }

    public void setRootContextLocator(RootContextLocator loc) {
        loc.setRootContext(this);
    }

    @Override
    public void close() {
        this.shutdown();
    }
}

