/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class MailboxAddress
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String user;
    public final String domain;
    public final String personal;

    static String removeSurroundingDelimiters(String p, String delim1, String delim2) {
        int pos = p.indexOf(delim1);
        if (pos >= 0) {
            p = p.substring(pos + 1);
        }
        if ((pos = p.indexOf(delim2)) >= 0) {
            p = p.substring(0, pos);
        }
        return p;
    }

    public static MailboxAddress parse(String address) throws IllegalArgumentException {
        if (address == null) {
            throw new IllegalArgumentException("address argument is null");
        }
        if (address.length() == 0) {
            throw new IllegalArgumentException("address argument is empty");
        }
        int posOpenBracket = address.indexOf("<");
        if (posOpenBracket > 0) {
            String p = address.substring(0, posOpenBracket - 1);
            p = MailboxAddress.removeSurroundingDelimiters(p, "\"", "\"");
            String add = address.substring(posOpenBracket + 1);
            String[] arr = (add = MailboxAddress.removeSurroundingDelimiters(add, "<", ">")).split("[@]");
            if (arr.length != 2) {
                throw new IllegalArgumentException("Not a valid email address: " + address);
            }
            return new MailboxAddress(arr[0], arr[1], p);
        }
        String[] arr = address.split("[@]");
        if (arr.length != 2) {
            throw new IllegalArgumentException("Not a valid email address: " + address);
        }
        return new MailboxAddress(arr[0], arr[1]);
    }

    public MailboxAddress(String user, String domain, String personal) {
        this.user = user;
        this.domain = domain;
        this.personal = personal;
    }

    public MailboxAddress(String user, String domain) {
        this.user = user;
        this.domain = domain;
        this.personal = null;
    }

    public String toString() {
        if (this.personal == null) {
            return this.toPlainAddress();
        }
        return "\"" + this.personal + "\"" + " <" + this.toPlainAddress() + ">";
    }

    public String toPlainAddress() {
        return this.user + "@" + this.domain;
    }

    public InternetAddress toInternetAddress() {
        try {
            if (this.personal == null) {
                return new InternetAddress(this.user + "@" + this.domain);
            }
            try {
                return new InternetAddress(this.user + "@" + this.domain, this.personal);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (AddressException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String getUser() {
        return this.user;
    }

    public String getDisplayName() {
        if (this.personal != null && this.personal.length() > 0) {
            return this.personal;
        }
        return this.user;
    }
}

