/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import io.milton.mail.Event;
import io.milton.mail.Filter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain {
    private static final Logger log = LoggerFactory.getLogger(FilterChain.class);
    final List<Filter> filters;
    final Filter terminal;
    int pos = 0;

    public FilterChain(List<Filter> filters, Filter terminal) {
        this.filters = filters;
        this.terminal = terminal;
    }

    public void doEvent(Event event) {
        if (this.pos < this.filters.size()) {
            Filter filter;
            if ((filter = this.filters.get(this.pos++)) != null) {
                filter.doEvent(this, event);
                return;
            }
            log.warn("Configuration problem. null filter at position: " + this.pos);
        }
        if (this.terminal != null) {
            this.terminal.doEvent(this, event);
        } else {
            log.warn("there appears to be no filters to process the request! Should be at least a terminal filter");
        }
    }
}

