/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.EDNSOption;
import io.milton.dns.record.Record;
import io.milton.dns.utils.base16;
import java.io.IOException;

public class GenericEDNSOption
extends EDNSOption {
    private byte[] data;

    GenericEDNSOption(int code) {
        super(code);
    }

    public GenericEDNSOption(int code, byte[] data) {
        super(code);
        this.data = Record.checkByteArrayLength("option data", data, 65535);
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        this.data = in.readByteArray();
    }

    @Override
    void optionToWire(DNSOutput out) {
        out.writeByteArray(this.data);
    }

    @Override
    String optionToString() {
        return "<" + base16.toString(this.data) + ">";
    }
}

