/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.Record;
import io.milton.dns.record.Tokenizer;
import java.io.IOException;

public class MINFORecord
extends Record {
    private static final long serialVersionUID = -3962147172340353796L;
    private Name responsibleAddress;
    private Name errorAddress;

    MINFORecord() {
    }

    @Override
    Record getObject() {
        return new MINFORecord();
    }

    public MINFORecord(Name name, int dclass, long ttl, Name responsibleAddress, Name errorAddress) {
        super(name, 14, dclass, ttl);
        this.responsibleAddress = MINFORecord.checkName("responsibleAddress", responsibleAddress);
        this.errorAddress = MINFORecord.checkName("errorAddress", errorAddress);
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.responsibleAddress = new Name(in);
        this.errorAddress = new Name(in);
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        this.responsibleAddress = st.getName(origin);
        this.errorAddress = st.getName(origin);
    }

    @Override
    String rrToString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.responsibleAddress);
        sb.append(" ");
        sb.append(this.errorAddress);
        return sb.toString();
    }

    public Name getResponsibleAddress() {
        return this.responsibleAddress;
    }

    public Name getErrorAddress() {
        return this.errorAddress;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        this.responsibleAddress.toWire(out, null, canonical);
        this.errorAddress.toWire(out, null, canonical);
    }
}

