/*
 * Decompiled with CFR 0.152.
 */
package io.milton.dns.record;

import io.milton.dns.Name;
import io.milton.dns.record.Compression;
import io.milton.dns.record.DNSInput;
import io.milton.dns.record.DNSOutput;
import io.milton.dns.record.Record;
import io.milton.dns.record.Tokenizer;
import java.io.IOException;

public class UNKRecord
extends Record {
    private static final long serialVersionUID = -4193583311594626915L;
    private byte[] data;

    UNKRecord() {
    }

    @Override
    Record getObject() {
        return new UNKRecord();
    }

    @Override
    void rrFromWire(DNSInput in) throws IOException {
        this.data = in.readByteArray();
    }

    @Override
    void rdataFromString(Tokenizer st, Name origin) throws IOException {
        throw st.exception("invalid unknown RR encoding");
    }

    @Override
    String rrToString() {
        return UNKRecord.unknownToString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    void rrToWire(DNSOutput out, Compression c, boolean canonical) {
        out.writeByteArray(this.data);
    }
}

