/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonSNIService {
    private static final Logger log = LoggerFactory.getLogger(MiltonSNIService.class);
    public static final int SECURE_PORT = 8443;
    public static final String SYS_SECURE_PORT = "secure.port";
    public static final String SNI_LISTENER_NAME = "SNI_SSL_TLS";
    private int port = 8443;
    private SNIFilter sniFilter = null;
    private TCPNIOTransport transport = null;
    private NetworkListener listenerSSL = null;
    private SSLEngineConfigurator sslDefEngineConfig = null;

    public MiltonSNIService(int port, SSLEngineConfigurator sslEngineConfigurator) {
        if (sslEngineConfigurator != null) {
            this.sslDefEngineConfig = sslEngineConfigurator;
        }
        this.port = port;
    }

    public void start(FilterChain filterChain, SNIServerConfigResolver sniServerConfigResolver) {
        this.sniFilter = new SNIFilter();
        this.sniFilter.setServerSSLConfigResolver(sniServerConfigResolver);
        FilterChainBuilder chainBuilder = FilterChainBuilder.stateless();
        chainBuilder.add((Filter)new TransportFilter());
        chainBuilder.add((Filter)this.sniFilter);
        Filter sslFilter = null;
        for (int i = 0; i < filterChain.size(); ++i) {
            sslFilter = (Filter)filterChain.get(i);
            if (sslFilter instanceof TransportFilter) continue;
            chainBuilder.add(sslFilter);
        }
        FilterChain filterChainNew = chainBuilder.build();
        this.transport = ((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setProcessor((Processor)filterChainNew)).build();
        try {
            this.transport.bind(this.port);
            this.transport.start();
            log.info("[HTTPS Service](SNI) start on port= " + this.port);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void shutdown() {
        if (this.transport != null) {
            this.transport.shutdown();
        }
        if (this.listenerSSL != null) {
            this.listenerSSL.shutdown();
        }
    }

    public void startOn(HttpServer httpServer) {
        if (this.sslDefEngineConfig == null || httpServer == null) {
            return;
        }
        this.listenerSSL = new NetworkListener(SNI_LISTENER_NAME, "0.0.0.0", new PortRange(this.port));
        this.listenerSSL.setSSLEngineConfig(this.sslDefEngineConfig);
        this.listenerSSL.setSecure(true);
        httpServer.addListener(this.listenerSSL);
        log.info("[HTTPS Service](SNI) start on port= " + this.port);
    }

    public boolean setupSNI(FilterChain filterChain, SNIServerConfigResolver sniServerConfigResolver) {
        log.info("setupSNI and filterChain is:" + filterChain);
        if (filterChain == null) {
            return false;
        }
        if (this.sniFilter == null) {
            this.sniFilter = new SNIFilter();
        }
        if (sniServerConfigResolver instanceof SNIServerConfigResolver) {
            log.info("setupSNI and sniServerConfigResolver is:" + sniServerConfigResolver);
            this.sniFilter.setServerSSLConfigResolver(sniServerConfigResolver);
        }
        Filter sslFilter = null;
        for (int i = 0; i < filterChain.size(); ++i) {
            sslFilter = (Filter)filterChain.get(i);
            if (sslFilter instanceof TransportFilter) {
                log.info("setup SNI and TransportFilter is removed. ");
                filterChain.remove(i--);
                continue;
            }
            if (!(sslFilter instanceof SSLBaseFilter)) continue;
            log.info("setup SNI and SSLBaseFilter is changed to be " + this.sniFilter);
            filterChain.set(i, (Object)this.sniFilter);
        }
        log.info("setupSNI: not found the sslFilter in FilterChain");
        return false;
    }
}

