/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http;

import io.milton.http.DateUtils;
import io.milton.http.FileItem;
import io.milton.http.Request;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest
implements Request {
    private final Logger log = LoggerFactory.getLogger(AbstractRequest.class);
    public static final int INFINITY = 3;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public abstract String getRequestHeader(Request.Header var1);

    public Date getIfModifiedHeader() {
        String s = this.getRequestHeader(Request.Header.IF_MODIFIED);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)s);
        }
        catch (DateUtils.DateParseException ex) {
            this.log.error("Unable to parse date: " + s, (Throwable)ex);
            return null;
        }
    }

    public String getIfRangeHeader() {
        return this.getRequestHeader(Request.Header.IF_RANGE);
    }

    public String getExpectHeader() {
        return this.getRequestHeader(Request.Header.EXPECT);
    }

    public String getAcceptHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT);
    }

    public String getAcceptLanguage() {
        return this.getRequestHeader(Request.Header.ACCEPT_LANGUAGE);
    }

    public String getRefererHeader() {
        return this.getRequestHeader(Request.Header.REFERER);
    }

    public String getContentTypeHeader() {
        return this.getRequestHeader(Request.Header.CONTENT_TYPE);
    }

    public String getAcceptEncodingHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT_ENCODING);
    }

    public String getUserAgentHeader() {
        return this.getRequestHeader(Request.Header.USER_AGENT);
    }

    public int getDepthHeader() {
        String depthStr = this.getRequestHeader(Request.Header.DEPTH);
        if (depthStr == null) {
            return 3;
        }
        if (depthStr.equals("0")) {
            return 0;
        }
        if (depthStr.equals("1")) {
            return 1;
        }
        if (depthStr.equals("infinity")) {
            return 3;
        }
        this.log.warn("Unknown depth value: " + depthStr);
        return 3;
    }

    public String getHostHeader() {
        return this.getRequestHeader(Request.Header.HOST);
    }

    public String getDestinationHeader() {
        return this.getRequestHeader(Request.Header.DESTINATION);
    }

    public Long getContentLengthHeader() {
        String s = this.getRequestHeader(Request.Header.CONTENT_LENGTH);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(s);
            return l;
        }
        catch (NumberFormatException ex) {
            this.log.warn("Couldnt parse content length header: " + s);
            return null;
        }
    }

    public String getTimeoutHeader() {
        return this.getRequestHeader(Request.Header.TIMEOUT);
    }

    public String getIfHeader() {
        return this.getRequestHeader(Request.Header.IF);
    }

    public String getLockTokenHeader() {
        return this.getRequestHeader(Request.Header.LOCK_TOKEN);
    }

    public String getRangeHeader() {
        return this.getRequestHeader(Request.Header.RANGE);
    }

    public String getContentRangeHeader() {
        return this.getRequestHeader(Request.Header.CONTENT_RANGE);
    }

    public Boolean getOverwriteHeader() {
        String s = this.getRequestHeader(Request.Header.OVERWRITE);
        if (s == null || s.length() == 0) {
            return null;
        }
        return "T".equals(s);
    }

    public String getIfMatchHeader() {
        return this.getRequestHeader(Request.Header.IF_MATCH);
    }

    public String getIfNoneMatchHeader() {
        return this.getRequestHeader(Request.Header.IF_NONE_MATCH);
    }

    public String getOriginHeader() {
        return this.getRequestHeader(Request.Header.ORIGIN);
    }

    public String getAbsolutePath() {
        return AbstractRequest.stripToPath(this.getAbsoluteUrl());
    }

    public static String stripToPath(String url) {
        int i = url.indexOf("/", 8);
        if (i > 0) {
            url = url.substring(i);
        }
        if ((i = url.indexOf("?")) > 0) {
            url = url.substring(0, i);
        }
        return url;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getParams() {
        return (Map)this.attributes.get("_params");
    }

    public Map<String, FileItem> getFiles() {
        return (Map)this.attributes.get("_files");
    }

    public Locale getLocale() {
        String header = this.getAcceptLanguage();
        if (header == null) {
            return null;
        }
        for (String str : header.split(",")) {
            Locale locale;
            String[] arr = str.trim().replace("-", "_").split(";");
            String[] l = arr[0].split("_");
            switch (l.length) {
                case 2: {
                    locale = new Locale(l[0], l[1]);
                    break;
                }
                case 3: {
                    locale = new Locale(l[0], l[1], l[2]);
                    break;
                }
                default: {
                    locale = new Locale(l[0]);
                }
            }
            if (locale == null) continue;
            return locale;
        }
        return null;
    }
}

