/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated.scheduling;

import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.http11.auth.DigestResponse;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.CollectionResource;
import io.milton.resource.DigestResource;
import io.milton.resource.ReportableResource;
import java.util.Date;

public abstract class BaseSchedulingResource
implements CollectionResource,
ReportableResource,
DigestResource {
    protected final CalDavPrincipal principal;
    protected final CalendarSearchService calendarSearchService;
    protected final String name;

    public BaseSchedulingResource(CalDavPrincipal principal, CalendarSearchService calendarSearchService, String name) {
        this.principal = principal;
        this.calendarSearchService = calendarSearchService;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueId() {
        return null;
    }

    public Object authenticate(String user, String password) {
        return this.principal.authenticate(user, password);
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return this.principal.authorise(request, method, auth);
    }

    public String getRealm() {
        return this.principal.getRealm();
    }

    public Date getModifiedDate() {
        return null;
    }

    public String checkRedirect(Request request) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public Object authenticate(DigestResponse digestRequest) {
        if (this.principal instanceof DigestResource) {
            DigestResource dr = (DigestResource)this.principal;
            return dr.authenticate(digestRequest);
        }
        return null;
    }

    public boolean isDigestAllowed() {
        if (this.principal instanceof DigestResource) {
            DigestResource dr = (DigestResource)this.principal;
            return dr.isDigestAllowed();
        }
        return false;
    }
}

