/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated.scheduling;

import io.milton.common.StringUtils;
import io.milton.http.Auth;
import io.milton.http.FileItem;
import io.milton.http.HttpManager;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.annotated.scheduling.BaseSchedulingResource;
import io.milton.http.annotated.scheduling.SchedulingXmlHelper;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.exceptions.NotFoundException;
import io.milton.principal.CalDavPrincipal;
import io.milton.resource.PostableResource;
import io.milton.resource.PropFindableResource;
import io.milton.resource.Resource;
import io.milton.resource.SchedulingResponseItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingOutboxResource
extends BaseSchedulingResource
implements PostableResource,
PropFindableResource {
    private static final Logger log = LoggerFactory.getLogger(SchedulingOutboxResource.class);
    private final SchedulingXmlHelper schedulingHelper = new SchedulingXmlHelper();
    private byte[] xmlResponse;

    public SchedulingOutboxResource(CalDavPrincipal principal, CalendarSearchService calendarSearchService, String name) {
        super(principal, calendarSearchService, name);
    }

    public List<SchedulingResponseItem> queryFreeBusy(String iCalText) {
        return this.calendarSearchService.queryFreeBusy(this.principal, iCalText);
    }

    public Resource child(String childName) throws NotAuthorizedException, BadRequestException {
        return null;
    }

    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        return Collections.EMPTY_LIST;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException, ConflictException {
        log.trace("process");
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Request request = HttpManager.request();
            IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)bout);
            String iCalText = bout.toString("UTF-8");
            if (log.isTraceEnabled()) {
                log.trace("Freebusy query: " + iCalText);
            }
            List<SchedulingResponseItem> respItems = this.queryFreeBusy(iCalText);
            String xml = this.schedulingHelper.generateXml(respItems);
            this.xmlResponse = xml.getBytes(StringUtils.UTF8);
            if (log.isTraceEnabled()) {
                log.trace("FreeBusy response= " + xml);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return null;
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException, NotFoundException {
        if (this.xmlResponse != null) {
            out.write(this.xmlResponse);
        }
    }

    public Long getMaxAgeSeconds(Auth auth) {
        return null;
    }

    public String getContentType(String accepts) {
        return "application/xml; charset=\"utf-8\"";
    }

    public Long getContentLength() {
        if (this.xmlResponse != null) {
            return this.xmlResponse.length;
        }
        return null;
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        if (method.equals((Object)Request.Method.POST)) {
            return auth != null && auth.getTag() != null;
        }
        return this.principal.authorise(request, method, auth);
    }

    public Date getCreateDate() {
        return null;
    }
}

