/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated.scheduling;

import io.milton.http.XmlWriter;
import io.milton.http.caldav.ITip;
import io.milton.resource.SchedulingResponseItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingXmlHelper {
    private static final Logger log = LoggerFactory.getLogger(SchedulingXmlHelper.class);
    private static final String CALDAV_PREFIX = "C";
    private final Helper helper = new Helper();

    public String generateXml(List<SchedulingResponseItem> respItems) throws UnsupportedEncodingException {
        log.trace("respondWithSchedulingResults: " + respItems.size());
        ByteArrayOutputStream generatedXml = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter(generatedXml);
        writer.writeXMLHeader();
        writer.open(CALDAV_PREFIX, "schedule-response " + this.helper.generateNamespaceDeclarations());
        writer.newLine();
        for (SchedulingResponseItem resp : respItems) {
            XmlWriter.Element elResp = writer.begin(CALDAV_PREFIX, "response");
            XmlWriter.Element elRecip = elResp.begin(CALDAV_PREFIX, "recipient");
            elRecip.begin("D", "href").writeText(resp.getRecipient(), false).close();
            elRecip.close();
            ITip.StatusResponse stat = resp.getStatus();
            elRecip.begin(CALDAV_PREFIX, "request-status").writeText(stat.code + ";" + stat.description, false).close();
            if (resp.getiCalText() != null) {
                elRecip.begin(CALDAV_PREFIX, "calendar-data").writeText(resp.getiCalText(), false).close();
            }
            elResp.close();
        }
        writer.close(CALDAV_PREFIX, "schedule-response");
        writer.flush();
        return generatedXml.toString("UTF-8");
    }

    private class Helper {
        private Helper() {
        }

        String generateNamespaceDeclarations() {
            return "xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\"";
        }

        void write(ByteArrayOutputStream out, OutputStream outputStream) {
            try {
                String xml = out.toString("UTF-8");
                outputStream.write(xml.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

