/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.values;

import io.milton.http.XmlWriter;
import io.milton.http.values.AddressDataTypeListValueWriter;
import io.milton.http.values.BooleanValueWriter;
import io.milton.http.values.CDataValueWriter;
import io.milton.http.values.DateValueWriter;
import io.milton.http.values.HrefListValueWriter;
import io.milton.http.values.ModifiedDateValueWriter;
import io.milton.http.values.PriviledgeListValueWriter;
import io.milton.http.values.ResourceTypeValueWriter;
import io.milton.http.values.SupportedReportSetWriter;
import io.milton.http.values.ToStringValueWriter;
import io.milton.http.values.UUIDValueWriter;
import io.milton.http.values.ValueAndType;
import io.milton.http.values.ValueWriter;
import io.milton.http.values.WrappedHrefWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueWriters {
    private static final Logger log = LoggerFactory.getLogger(ValueWriters.class);
    private final List<ValueWriter> writers;

    public ValueWriters(List<ValueWriter> valueWriters) {
        this.writers = valueWriters;
    }

    public ValueWriters() {
        this.writers = new ArrayList<ValueWriter>();
        this.writers.add(new ModifiedDateValueWriter());
        this.writers.add(new DateValueWriter());
        this.writers.add(new ResourceTypeValueWriter());
        this.writers.add(new BooleanValueWriter());
        this.writers.add(new CDataValueWriter());
        this.writers.add(new UUIDValueWriter());
        this.writers.add(new HrefListValueWriter());
        this.writers.add(new WrappedHrefWriter());
        this.writers.add(new SupportedReportSetWriter());
        this.writers.add(new AddressDataTypeListValueWriter());
        this.writers.add(new PriviledgeListValueWriter());
        this.writers.add(new ToStringValueWriter());
    }

    public void writeValue(XmlWriter writer, QName qname, String prefix, ValueAndType vat, String href, Map<String, String> nsPrefixes) {
        for (ValueWriter vw : this.writers) {
            if (log.isTraceEnabled() && vat.getValue() != null && vat.getValue().getClass() != vat.getType()) {
                throw new RuntimeException("Inconsistent type information: " + vat.getValue().getClass() + " != " + vat.getType());
            }
            if (!vw.supports(qname.getNamespaceURI(), qname.getLocalPart(), vat.getType())) continue;
            vw.writeValue(writer, qname.getNamespaceURI(), prefix, qname.getLocalPart(), vat.getValue(), href, nsPrefixes);
            break;
        }
    }

    public List<ValueWriter> getValueWriters() {
        return this.writers;
    }

    public Object parse(QName qname, Class valueType, String value) {
        for (ValueWriter vw : this.writers) {
            if (!vw.supports(qname.getNamespaceURI(), qname.getLocalPart(), valueType)) continue;
            log.trace("parse: Found supporting value writer {} ", (Object)vw);
            return vw.parse(qname.getNamespaceURI(), qname.getLocalPart(), value);
        }
        log.warn("parse: No value writer supports: qname: " + qname + " type:" + valueType + " value:" + value);
        return null;
    }
}

