/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.annotations.BeanPropertyResource;
import io.milton.common.LogUtils;
import io.milton.http.Auth;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.ldap.Condition;
import io.milton.ldap.LdapPrincipal;
import io.milton.ldap.LdapUtils;
import io.milton.ldap.MapContact;
import io.milton.ldap.UserFactory;
import io.milton.resource.LdapContact;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryUserSessionFactory
implements UserFactory {
    private static final Logger log = LoggerFactory.getLogger(MemoryUserSessionFactory.class);
    private final Map<String, MemoryUser> users;

    public MemoryUserSessionFactory(Map<String, MemoryUser> users) {
        this.users = users;
    }

    public MemoryUserSessionFactory() {
        this.users = new HashMap<String, MemoryUser>();
    }

    public void addUser(String name, String password, String givenName, String surname, String email) {
        MemoryUser u = new MemoryUser(name, password, givenName, surname);
        u.setMail(email);
        this.users.put(name, u);
    }

    public MemoryUser getUser(String userName) {
        MemoryUser u = this.users.get(userName);
        LogUtils.debug((Logger)log, (Object[])new Object[]{"getUser", userName, "result=", u});
        return u;
    }

    @Override
    public String getUserPassword(String userName) {
        MemoryUser user = this.getUser(userName);
        if (user == null) {
            LogUtils.warn((Logger)log, (Object[])new Object[]{"getUserPassword: user not found", userName});
            return null;
        }
        return user.getPassword();
    }

    @Override
    public LdapPrincipal getUser(String userName, String password) {
        MemoryUser user = this.getUser(userName);
        if (user == null) {
            LogUtils.warn((Logger)log, (Object[])new Object[]{"getUser: user not found", userName});
            return null;
        }
        if (password.equals(user.getPassword())) {
            LogUtils.debug((Logger)log, (Object[])new Object[]{"getUser: user authentuicated ok", userName});
            return user;
        }
        LogUtils.warn((Logger)log, (Object[])new Object[]{"getUser: incorrect password", userName});
        return null;
    }

    @Override
    public List<LdapContact> galFind(Condition condition, int sizeLimit) throws NotAuthorizedException, BadRequestException {
        log.trace("galFind");
        ArrayList<LdapContact> results = new ArrayList<LdapContact>();
        for (MemoryUser user : this.users.values()) {
            if (condition != null && !condition.isMatch(user)) continue;
            LogUtils.debug((Logger)log, (Object[])new Object[]{"searchContacts: add to results", user.userName});
            results.add(user);
            if (results.size() < sizeLimit) continue;
            break;
        }
        LogUtils.debug((Logger)log, (Object[])new Object[]{"galFind: results: ", results.size()});
        return results;
    }

    @BeanPropertyResource(value="ldap")
    public class MemoryUser
    extends MapContact
    implements LdapPrincipal,
    LdapContact {
        private final String userName;
        private String password;

        public MemoryUser(String alias, String password, String givenName, String surname) {
            super(alias);
            this.userName = alias;
            this.password = password;
            this.put("imapUid", alias);
            this.put("uid", alias);
            this.put("etag", alias + this.hashCode());
            Date dtBirth = new Date();
            String sBirth = LdapUtils.getZuluDateFormat().format(dtBirth);
            this.put("birth", sBirth);
            this.put("bday", sBirth);
            this.put("im", alias);
            this.setGivenName(givenName);
            this.setSurName(surname);
            this.put("cn", givenName + " " + surname);
        }

        @Override
        public List<LdapContact> searchContacts(Condition condition, int maxCount) {
            return Collections.EMPTY_LIST;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEtag() {
            return this.hashCode() + "";
        }

        public String getGivenName() {
            return (String)this.get("givenName");
        }

        public final void setGivenName(String givenName) {
            this.put("givenName", givenName);
        }

        public String getSurName() {
            return (String)this.get("sn");
        }

        public final void setSurName(String surname) {
            this.put("sn", surname);
        }

        public String getMail() {
            return (String)this.get("mail");
        }

        public void setMail(String s) {
            this.put("mail", s);
        }

        public String getCommonName() {
            return this.getGivenName() + " " + this.getSurName();
        }

        @Override
        public Date getCreateDate() {
            return null;
        }

        @Override
        public String getName() {
            return this.userName;
        }

        @Override
        public Object authenticate(String user, String password) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean authorise(Request request, Request.Method method, Auth auth) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getRealm() {
            return "ldap";
        }

        @Override
        public Date getModifiedDate() {
            return null;
        }

        @Override
        public String checkRedirect(Request request) {
            return null;
        }
    }
}

