/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import com.sun.jndi.ldap.BerDecoder;
import io.milton.common.LogUtils;
import io.milton.ldap.Ldap;
import io.milton.ldap.LdapConnection;
import io.milton.ldap.LdapTransactionManager;
import io.milton.ldap.SearchRunnable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchManager {
    private static final Logger log = LoggerFactory.getLogger(SearchManager.class);
    private final HashMap<LdapConnection, Map<Integer, SearchRunnable>> mapOfSearchesByConnection = new HashMap();
    private final HashMap<UUID, LdapConnection> mapOfUuids = new HashMap();
    private final LdapTransactionManager txManager;

    public SearchManager(LdapTransactionManager txManager) {
        this.txManager = txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, SearchRunnable> getThreadMap(LdapConnection connection) {
        HashMap<LdapConnection, Map<Integer, SearchRunnable>> hashMap = this.mapOfSearchesByConnection;
        synchronized (hashMap) {
            Map<Integer, SearchRunnable> map = this.mapOfSearchesByConnection.get(connection);
            if (map == null) {
                map = new HashMap<Integer, SearchRunnable>();
                this.mapOfSearchesByConnection.put(connection, map);
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllSearches(LdapConnection aThis) {
        Map<Integer, SearchRunnable> searchThreadMap;
        Map<Integer, SearchRunnable> map = searchThreadMap = this.getThreadMap(aThis);
        synchronized (map) {
            for (SearchRunnable searchRunnable : searchThreadMap.values()) {
                searchRunnable.abandon();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAsyncSearch(LdapConnection aThis, int currentMessageId, final SearchRunnable searchRunnable) {
        Map<Integer, SearchRunnable> searchThreadMap;
        searchRunnable.setUuid(UUID.randomUUID());
        Map<Integer, SearchRunnable> map = searchThreadMap = this.getThreadMap(aThis);
        synchronized (map) {
            searchThreadMap.put(currentMessageId, searchRunnable);
            this.mapOfUuids.put(searchRunnable.getUuid(), aThis);
        }
        Runnable runnableRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchManager.this.txManager.tx(searchRunnable);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        Thread searchThread = new Thread(runnableRunner);
        searchThread.setName(aThis.getName() + "-Search-" + currentMessageId);
        searchThread.start();
    }

    public void search(LdapConnection aThis, SearchRunnable searchRunnable) {
        searchRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonSearch(LdapConnection aThis, int currentMessageId, BerDecoder reqBer) {
        int abandonMessageId = 0;
        try {
            Map<Integer, SearchRunnable> searchThreadMap;
            abandonMessageId = (Integer)Ldap.PARSE_INT_WITH_TAG_METHOD.invoke((Object)reqBer, 80);
            Map<Integer, SearchRunnable> map = searchThreadMap = this.getThreadMap(aThis);
            synchronized (map) {
                SearchRunnable searchRunnable = searchThreadMap.get(abandonMessageId);
                if (searchRunnable != null) {
                    searchRunnable.abandon();
                    searchThreadMap.remove(currentMessageId);
                }
            }
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("", (Throwable)e);
        }
        LogUtils.debug((Logger)log, (Object[])new Object[]{"LOG_LDAP_REQ_ABANDON_SEARCH", currentMessageId, abandonMessageId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchComplete(UUID id, Integer currentMessageId) {
        LdapConnection con = this.mapOfUuids.get(id);
        if (con != null) {
            Map<Integer, SearchRunnable> searchThreadMap;
            Map<Integer, SearchRunnable> map = searchThreadMap = this.getThreadMap(con);
            synchronized (map) {
                searchThreadMap.remove(currentMessageId);
            }
        }
    }
}

