/*
 * Decompiled with CFR 0.152.
 */
package io.milton.restlet;

import io.milton.http.AbstractRequest;
import io.milton.http.Auth;
import io.milton.http.Cookie;
import io.milton.http.Request;
import io.milton.http.RequestParseException;
import io.milton.restlet.CookieAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.engine.adapter.HttpRequest;
import org.restlet.engine.header.Header;
import org.restlet.util.Series;

public class RequestAdapter
extends AbstractRequest {
    protected final HttpRequest target;
    protected Auth auth;

    RequestAdapter(HttpRequest target) {
        this.target = target;
    }

    public HttpRequest getTarget() {
        return this.target;
    }

    protected Series<Header> getRawHeaders() {
        return this.getTarget().getHttpCall().getRequestHeaders();
    }

    @Override
    public String getRequestHeader(Request.Header header) {
        return this.getRawHeaders().getValues(header.code);
    }

    public Map<String, String> getHeaders() {
        return this.getRawHeaders().getValuesMap();
    }

    public String getFromAddress() {
        return this.getTarget().getClientInfo().getAddress();
    }

    public String getRemoteAddr() {
        return this.getTarget().getClientInfo().getAddress();
    }

    public Request.Method getMethod() {
        return Request.Method.valueOf((String)this.getTarget().getMethod().getName());
    }

    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null) {
            return null;
        }
        if (enc.length() == 0) {
            return null;
        }
        this.auth = new Auth(enc);
        return this.auth;
    }

    public void setAuthorization(Auth auth) {
        this.auth = auth;
    }

    public String getAbsoluteUrl() {
        return this.getTarget().getOriginalRef().toString();
    }

    public InputStream getInputStream() throws IOException {
        InputStream stream;
        if (this.getTarget().getEntity() != null && this.getTarget().getEntity().isAvailable() && (stream = this.getTarget().getEntity().getStream()) != null) {
            return stream;
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
    }

    public void parseRequestParameters(Map<String, String> params, Map<String, io.milton.http.FileItem> files) throws RequestParseException {
        if (this.getTarget().getOriginalRef().hasQuery()) {
            params.putAll(this.getTarget().getOriginalRef().getQueryAsForm(true).getValuesMap());
        }
        if (this.getTarget().getEntity() != null && this.getTarget().getEntity().isAvailable()) {
            if (MediaType.APPLICATION_WWW_FORM.equals((Object)this.getTarget().getEntity().getMediaType(), true)) {
                params.putAll(new Form(this.getTarget().getEntity(), true).getValuesMap());
            } else if (MediaType.MULTIPART_FORM_DATA.equals((Object)this.getTarget().getEntity().getMediaType(), true)) {
                throw new UnsupportedOperationException("Multipart file uploading not implemented");
            }
        }
    }

    public Cookie getCookie(String name) {
        if (this.getTarget().getCookies().size() > 0) {
            for (org.restlet.data.Cookie cookie : this.getTarget().getCookies()) {
                if (!cookie.getName().equals(name)) continue;
                return new CookieAdapter(cookie);
            }
        }
        return null;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (org.restlet.data.Cookie cookie : this.getTarget().getCookies()) {
            cookies.add(new CookieAdapter(cookie));
        }
        return cookies;
    }

    public static class FileItemWrapper
    implements io.milton.http.FileItem {
        final FileItem wrapped;
        final String name;

        public static String fixIEFileName(String s) {
            if (s.contains("\\")) {
                int pos = s.lastIndexOf(92);
                s = s.substring(pos + 1);
            }
            return s;
        }

        public FileItemWrapper(FileItem wrapped) {
            this.wrapped = wrapped;
            this.name = FileItemWrapper.fixIEFileName(wrapped.getName());
        }

        public String getContentType() {
            return this.wrapped.getContentType();
        }

        public String getFieldName() {
            return this.wrapped.getFieldName();
        }

        public InputStream getInputStream() {
            try {
                return this.wrapped.getInputStream();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public OutputStream getOutputStream() {
            try {
                return this.wrapped.getOutputStream();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getName() {
            return this.name;
        }

        public long getSize() {
            return this.wrapped.getSize();
        }
    }
}

