/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.http.HttpManager;
import io.milton.http.http11.Http11ResponseHandler;
import io.milton.simpleton.SimpleMiltonRequest;
import io.milton.simpleton.SimpleMiltonResponse;
import io.milton.simpleton.Stage;
import io.milton.simpleton.Task;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.simpleframework.http.Request;
import org.simpleframework.http.Response;
import org.simpleframework.http.core.Container;
import org.simpleframework.http.core.ContainerServer;
import org.simpleframework.transport.Server;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.connect.Connection;
import org.simpleframework.transport.connect.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslSimpletonServer
implements Container {
    private static final Logger log = LoggerFactory.getLogger(SslSimpletonServer.class);
    public static final String DEFAULT_KEYSTORE_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    protected final Stage<Task> dispatchStage;
    private final HttpManager httpManager;
    private final Http11ResponseHandler responseHandler;
    private int sslPort = 443;
    private File keystoreFile;
    private String keystorePassword;
    private Thread thMonitor;
    private boolean stopped;
    private int maxQueueTimeMillis = 10000;
    private int maxProcessTimeMillis = 60000;
    private Connection connection;
    private Connection sslConnection;
    private String sslProtocol = "TLS";
    private String keystoreType = "JKS";
    private String keystoreAlgorithm = DEFAULT_KEYSTORE_ALGORITHM;

    public SslSimpletonServer(HttpManager httpManager, Http11ResponseHandler responseHandler, int capacity, int numThreads) {
        this.httpManager = httpManager;
        this.dispatchStage = new Stage("dispatchStage", capacity, numThreads, false);
        this.responseHandler = responseHandler;
        this.thMonitor = new Thread(new TaskMonitor());
    }

    public void start() {
        this.stopped = false;
        this.sslConnection = this.initHttps(this.sslPort);
        this.thMonitor = new Thread(new TaskMonitor());
        this.thMonitor.start();
    }

    protected SocketConnection initHttps(int port) {
        SSLServerSocketFactory fac = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        log.info("initHttps: port: " + port + " sslProtocol: " + this.sslProtocol + " keystoreAlgorithm:" + this.keystoreAlgorithm);
        try {
            KeyStore keystore = KeyStore.getInstance(this.keystoreType);
            keystore.load(new FileInputStream(this.keystoreFile), this.keystorePassword.toCharArray());
            log.info("listing aliases defined in keystore");
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String a = aliases.nextElement();
                log.info(" - alias: " + a);
                Certificate cert = keystore.getCertificate(a);
                log.info("   - cert type: " + cert.getType());
                log.info("   - algorithm: " + cert.getPublicKey().getAlgorithm());
                log.info("   - format: " + cert.getPublicKey().getFormat());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keystoreAlgorithm);
            kmf.init(keystore, this.keystorePassword.toCharArray());
            AnonymousTrustManager trustManager = new AnonymousTrustManager();
            TrustManager[] trustManagers = new X509TrustManager[]{trustManager};
            SSLContext sslc = SSLContext.getInstance(this.sslProtocol);
            sslc.init(kmf.getKeyManagers(), trustManagers, null);
            ContainerServer processor = new ContainerServer((Container)this, 25);
            SecureProcessor secure = new SecureProcessor(processor, sslc);
            SocketConnection ssl = new SocketConnection((Server)secure);
            InetSocketAddress address = new InetSocketAddress(port);
            ssl.connect((SocketAddress)address, sslc);
            log.debug("server running on: " + address);
            return ssl;
        }
        catch (BindException ex) {
            throw new RuntimeException("Couldnt bind to port: " + port);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        catch (CertificateException ex) {
            throw new RuntimeException(ex);
        }
        catch (KeyStoreException ex) {
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        try {
            this.dispatchStage.close();
        }
        catch (IOException ex) {
            log.error("exception closing dispatchStage", (Throwable)ex);
        }
        this.stopped = true;
        this.thMonitor.interrupt();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                log.error("exception closing http connection", (Throwable)ex);
            }
        }
        if (this.sslConnection != null) {
            try {
                this.sslConnection.close();
            }
            catch (Exception ex) {
                log.error("exception closing ssl connection", (Throwable)ex);
            }
        }
    }

    public void handle(Request request, Response response) {
        Task task = new Task(this.httpManager, request, response);
        try {
            this.dispatchStage.enqueue(task);
        }
        catch (Exception e) {
            log.warn("exception dispatching request: " + e.getMessage());
            SimpleMiltonRequest req = new SimpleMiltonRequest(request);
            SimpleMiltonResponse resp = new SimpleMiltonResponse(response);
            this.respondError(req, resp, e.getMessage());
        }
    }

    public void respondError(SimpleMiltonRequest req, SimpleMiltonResponse resp, String reason) {
        this.responseHandler.respondServerError(req, resp, reason);
    }

    private void respondError(Task t) {
        try {
            log.warn("setting error status becaue request could not be processed");
            t.response.setCode(500);
            t.response.close();
        }
        catch (Exception e) {
            log.error("error setting last chance error status", (Throwable)e);
        }
    }

    public Integer getHttpPort() {
        return this.sslPort;
    }

    public void setHttpPort(Integer sslPort) {
        this.sslPort = sslPort;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public String getKeystoreAlgorithm() {
        return this.keystoreAlgorithm;
    }

    public void setKeystoreAlgorithm(String keystoreAlgorithm) {
        this.keystoreAlgorithm = keystoreAlgorithm;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public int getMaxProcessTimeMillis() {
        return this.maxProcessTimeMillis;
    }

    public void setMaxProcessTimeMillis(int maxProcessTimeMillis) {
        this.maxProcessTimeMillis = maxProcessTimeMillis;
    }

    public int getMaxQueueTimeMillis() {
        return this.maxQueueTimeMillis;
    }

    public void setMaxQueueTimeMillis(int maxQueueTimeMillis) {
        this.maxQueueTimeMillis = maxQueueTimeMillis;
    }

    private void checkTasks() {
        for (Task t : this.dispatchStage.queue) {
            long l = System.currentTimeMillis() - t.enqueueTime;
            if (l > (long)this.maxQueueTimeMillis) {
                log.warn("XXX task is too long in queue: " + l + "ms. " + t);
                log.warn("Queue Size: " + this.dispatchStage.queue.size());
                log.warn("listing contents of queue -");
                for (Task q : this.dispatchStage.queue) {
                    log.warn(" - " + q.request.getTarget());
                }
                log.warn("---");
                this.dispatchStage.queue.remove(t);
                this.respondError(t);
                continue;
            }
            if (t.startTime <= 0L || (l = System.currentTimeMillis() - t.startTime) <= (long)this.maxProcessTimeMillis) continue;
            log.warn("**** task is too long being processed: " + l + "ms. " + t);
            t.thisThread.interrupt();
        }
    }

    private static class SecureProcessor
    implements Server {
        private final ContainerServer processor;
        private final SSLContext context;

        public SecureProcessor(ContainerServer processor, SSLContext context) {
            this.processor = processor;
            this.context = context;
        }

        public void process(Socket pipeline) throws IOException {
            final SocketChannel channel = pipeline.getChannel();
            final HashMap map = new HashMap();
            Socket secure = new Socket(){
                private SSLEngine engine;

                public Map getAttributes() {
                    return map;
                }

                public SocketChannel getChannel() {
                    return channel;
                }

                public SSLEngine getEngine() {
                    if (this.engine == null) {
                        this.engine = SecureProcessor.this.context.createSSLEngine();
                    }
                    return this.engine;
                }
            };
            this.processor.process(secure);
        }

        public void stop() {
        }
    }

    public static class AnonymousTrustManager
    implements X509TrustManager {
        public boolean isClientTrusted(X509Certificate[] cert) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] cert) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }
    }

    public class TaskMonitor
    implements Runnable {
        @Override
        public void run() {
            boolean isInterrupted = false;
            while (!SslSimpletonServer.this.stopped && !isInterrupted) {
                SslSimpletonServer.this.checkTasks();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    log.debug("interrupted");
                    isInterrupted = true;
                }
            }
        }
    }
}

