/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ftp;

public class NameAndAuthority {
    public static final String DELIM_HOST = "#";
    public static final String DELIM_AUTHORITY = ":";
    public final String name;
    public final String domain;
    public final String authority;

    public static NameAndAuthority parse(String user) {
        if (user == null) {
            return new NameAndAuthority(null);
        }
        int pos = user.indexOf(DELIM_HOST);
        if (pos < 0) {
            return new NameAndAuthority(user);
        }
        String name = user.substring(0, pos);
        String authority = user.substring(pos + 1, user.length());
        if ((pos = authority.indexOf(DELIM_AUTHORITY)) < 0) {
            return new NameAndAuthority(name, authority, authority);
        }
        String domain = authority.substring(pos + 1, authority.length());
        authority = authority.substring(0, pos);
        return new NameAndAuthority(name, authority, domain);
    }

    public NameAndAuthority(String name) {
        this(name, null, null);
    }

    public NameAndAuthority(String name, String authority, String domain) {
        this.name = name;
        this.authority = authority;
        this.domain = domain;
    }

    public String toMilton() {
        if (this.authority == null) {
            return this.name;
        }
        return this.name + "@" + this.authority;
    }
}

