/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import io.milton.config.HttpManagerBuilder;
import io.milton.grizzly.GrizzlyMiltonRequest;
import io.milton.grizzly.GrizzlyMiltonResponse;
import io.milton.grizzly.MiltonSNICertificateManager;
import io.milton.grizzly.MiltonSNICertificateStore;
import io.milton.grizzly.MiltonSNIService;
import io.milton.http.HttpManager;
import io.milton.http.ResourceFactory;
import io.milton.mail.MailServer;
import io.milton.mail.MailServerBuilder;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class GrizzlyServer {
    private static final Logger log = LoggerFactory.getLogger(GrizzlyServer.class);
    private HttpServer httpServer;
    private StaticApplicationContext parent;
    private HttpManager httpManager;
    private MailServer mailServer;
    private MiltonSNIService kademiSNIService;
    private boolean running;

    public static void main(String[] args) throws IOException, InterruptedException {
        int port = 8080;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        Integer sslPort = null;
        if (args.length > 1) {
            sslPort = Integer.parseInt(args[1]);
        }
        GrizzlyServer k = new GrizzlyServer();
        k.start();
        System.out.println("Press any key to stop the server...");
        System.in.read();
    }

    public void start() throws IOException {
        this.start(8080);
    }

    public void start(int httpPort) throws IOException {
        this.start(httpPort, null);
    }

    public boolean start(int httpPort, Integer sslPort) throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ConfigurableApplicationContext ctx = this.initSpringApplicationContext();
        if (ctx == null) {
            log.warn("Failed to initialise spring");
            return false;
        }
        Object milton = ctx.getBean("milton.http.manager");
        if (milton instanceof HttpManager) {
            this.httpManager = (HttpManager)milton;
        } else if (milton instanceof HttpManagerBuilder) {
            HttpManagerBuilder builder = (HttpManagerBuilder)milton;
            ResourceFactory rf = builder.getMainResourceFactory();
            this.httpManager = builder.buildHttpManager();
        }
        if (this.parent.containsBean("milton.mail.server")) {
            log.info("init mailserver...");
            Object oMailServer = this.parent.getBean("milton.mail.server");
            if (oMailServer instanceof MailServer) {
                this.mailServer = (MailServer)oMailServer;
            } else if (oMailServer instanceof MailServerBuilder) {
                MailServerBuilder builder = (MailServerBuilder)oMailServer;
                this.mailServer = builder.build();
            } else {
                throw new RuntimeException("Unsupported type: " + oMailServer.getClass() + " expected " + MailServer.class + " or " + MailServerBuilder.class);
            }
            log.info("starting mailserver");
            this.mailServer.start();
        }
        log.info("Finished init");
        String host = GrizzlyServer.getPropertyOrDefault("host", null);
        int port = this.getPropertyOrDefaultInt("port", 8080);
        int secureHttpPort = this.getPropertyOrDefaultInt("secure.port", 8443);
        this.httpServer = host == null ? HttpServer.createSimpleServer(null, (int)port) : HttpServer.createSimpleServer(null, (String)host, (int)port);
        MiltonSNICertificateStore store = null;
        MiltonSNICertificateManager sniCerManager = new MiltonSNICertificateManager(ctx, store);
        SSLEngineConfigurator sniConfig = sniCerManager.createEngineConfigurator();
        this.kademiSNIService = new MiltonSNIService(secureHttpPort, sniConfig);
        this.kademiSNIService.startOn(this.httpServer);
        this.httpServer.getServerConfiguration().addHttpHandler(new HttpHandler(){

            public void service(Request request, Response response) throws Exception {
                log.trace("service");
                GrizzlyMiltonRequest req = new GrizzlyMiltonRequest(request);
                GrizzlyMiltonResponse resp = new GrizzlyMiltonResponse(response);
                String p = req.getAbsolutePath();
                long tm = System.currentTimeMillis();
                GrizzlyServer.this.httpManager.process(req, resp);
                tm = System.currentTimeMillis() - tm;
            }
        }, new String[]{"/"});
        this.httpServer.start();
        this.running = true;
        return true;
    }

    protected ConfigurableApplicationContext initSpringApplicationContext() {
        log.info("No root spring context");
        this.parent = new StaticApplicationContext();
        ClassPathXmlApplicationContext ctx = null;
        String[] contextFiles = new String[]{"applicationContext.xml"};
        this.parent.refresh();
        try {
            ctx = new ClassPathXmlApplicationContext(contextFiles, (ApplicationContext)this.parent);
        }
        catch (BeansException e) {
            log.error("Unable to create a child context for Milton", (Throwable)e);
        }
        return ctx;
    }

    private int getPropertyOrDefaultInt(String propSuffix, int defaultVal) {
        String name = "kademi." + propSuffix;
        String s = System.getProperty(name);
        if (StringUtils.isNotBlank((String)s)) {
            log.info("Using System property: " + name + " = " + s);
            return Integer.parseInt(s);
        }
        log.info("Using default value " + defaultVal + " for property " + name);
        return defaultVal;
    }

    public static String getPropertyOrDefault(String propSuffix, String defaultVal) {
        String name = "kademi." + propSuffix;
        String s = System.getProperty(name);
        if (StringUtils.isNotBlank((String)s)) {
            log.info("Using System property: " + name + " = " + s);
            return s;
        }
        log.info("Using default value " + defaultVal + " for property " + name);
        return defaultVal;
    }
}

