/*
 * Decompiled with CFR 0.152.
 */
package io.milton.grizzly;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Base64;

public class SSLTools {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static Certificate parseCertificate(String certificateText) throws CertificateException {
        return SSLTools.parseCertificate(certificateText.getBytes());
    }

    public static Certificate parseCertificate(byte[] certificateBytes) throws CertificateException {
        if (certificateBytes.length == 0) {
            throw new RuntimeException("Empty certificate");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(certificateBytes);
        try {
            Certificate cert = cf.generateCertificate(bais);
            return cert;
        }
        catch (CertificateException certificateException) {
            throw new CertificateException("Could not read certificate", certificateException);
        }
    }

    public static X509Certificate parseX509Certificate(String certificateText) throws CertificateException {
        return (X509Certificate)SSLTools.parseCertificate(certificateText);
    }

    public static X509Certificate parseX509Certificate(byte[] certificateBytes) throws CertificateException {
        return (X509Certificate)SSLTools.parseCertificate(certificateBytes);
    }

    public static PrivateKey parsePrivateKey(String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyText, null);
    }

    public static PrivateKey parsePrivateKey(String privateKeyText, char[] password) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyText.getBytes(), password);
    }

    public static PrivateKey parsePrivateKey(byte[] privateKeyBytes) throws GeneralSecurityException, IOException {
        return SSLTools.parsePrivateKey(privateKeyBytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey parsePrivateKey(byte[] privateKeyBytes, char[] password) throws GeneralSecurityException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(privateKeyBytes);
        InputStreamReader reader = new InputStreamReader(bais);
        PEMReader parser = null;
        try {
            parser = password != null ? new PEMReader((Reader)reader, SSLTools.getPasswordFinder(password)) : new PEMReader((Reader)reader);
            KeyPair caKeyPair = (KeyPair)parser.readObject();
            if (caKeyPair == null) {
                throw new GeneralSecurityException("Reading CA private key failed");
            }
            PrivateKey privateKey = caKeyPair.getPrivate();
            return privateKey;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            bais.close();
            reader.close();
        }
    }

    public static KeyPair parseKeyPair(String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.parseKeyPair(privateKeyText.getBytes(), null);
    }

    public static KeyPair parseKeyPair(String privateKeyText, String password) throws GeneralSecurityException, IOException {
        return SSLTools.parseKeyPair(privateKeyText.getBytes(), password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair parseKeyPair(byte[] privateKeyBytes, String password) throws GeneralSecurityException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(privateKeyBytes);
        InputStreamReader reader = new InputStreamReader(bais);
        PEMReader parser = null;
        try {
            parser = password != null ? new PEMReader((Reader)reader, SSLTools.getPasswordFinder(password)) : new PEMReader((Reader)reader);
            KeyPair caKeyPair = (KeyPair)parser.readObject();
            if (caKeyPair == null) {
                throw new GeneralSecurityException("Reading CA private key failed");
            }
            KeyPair keyPair = caKeyPair;
            return keyPair;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
            bais.close();
            reader.close();
        }
    }

    public static PublicKey getPublicKeyFromPrivateKey(byte[] privateKeyBytes, String password) throws IOException, GeneralSecurityException {
        KeyPair keypair = SSLTools.parseKeyPair(privateKeyBytes, password);
        return keypair.getPublic();
    }

    public static RSAPrivateKey parseRSAPrivateKey(String privateKeyText, char[] password) throws GeneralSecurityException, IOException {
        return (RSAPrivateKey)SSLTools.parsePrivateKey(privateKeyText, password);
    }

    public static RSAPrivateKey parseRSAPrivateKey(String privateKeyText) throws GeneralSecurityException, IOException {
        return (RSAPrivateKey)SSLTools.parsePrivateKey(privateKeyText, null);
    }

    public static PublicKey parsePublicKey(String publicKeyPEM) throws IOException {
        return (PublicKey)SSLTools.pemReader(publicKeyPEM);
    }

    public static String getCertificateModulusSHA1(X509Certificate cert) throws NoSuchAlgorithmException {
        PublicKey publicKey = cert.getPublicKey();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("Certificate file does not contain an RSA public key but a " + publicKey.getClass().getName());
        }
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        byte[] certModulusData = rsaPublicKey.getModulus().toByteArray();
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] certID = sha1.digest(certModulusData);
        String certIDinHex = SSLTools.toHexString(certID);
        return certIDinHex;
    }

    public static String getPrivateKeyModulusSHA1(RSAPrivateKey rsaPrivateKey) {
        byte[] keyModulusData = rsaPrivateKey.getModulus().toByteArray();
        byte[] keyID = DigestUtils.sha1((byte[])keyModulusData);
        String keyIDinHex = SSLTools.toHexString(keyID);
        return keyIDinHex;
    }

    public static boolean isCertificateValid(String certificateText, String privateKeyText) throws GeneralSecurityException, IOException {
        return SSLTools.isCertificateValid(certificateText, privateKeyText, null);
    }

    public static boolean isCertificateValid(String certificateText, String privateKeyText, char[] privateKeyPassword) throws GeneralSecurityException, IOException {
        RSAPrivateKey pk = SSLTools.parseRSAPrivateKey(privateKeyText, privateKeyPassword);
        X509Certificate certificate = SSLTools.parseX509Certificate(certificateText);
        return SSLTools.isCertificateValid(certificate, pk);
    }

    public static boolean isCertificateValid(X509Certificate cert, RSAPrivateKey privateKey) throws NoSuchAlgorithmException {
        String certIDinHex = SSLTools.getCertificateModulusSHA1(cert);
        String keyIDinHex = SSLTools.getPrivateKeyModulusSHA1(privateKey);
        return certIDinHex.equalsIgnoreCase(keyIDinHex);
    }

    public static PasswordFinder getPasswordFinder(final String password) {
        return new PasswordFinder(){

            public char[] getPassword() {
                char[] pass = password.toCharArray();
                return pass;
            }
        };
    }

    public static PasswordFinder getPasswordFinder(final char[] password) {
        return new PasswordFinder(){

            public char[] getPassword() {
                char[] pass = password;
                return pass;
            }
        };
    }

    public static String getDkimDnsTxt(String privateKeyText) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        sb.append("v=DKIM1; k=rsa; ");
        String cleanedPem = SSLTools.cleanRSAPrivateKeyPem(privateKeyText);
        PublicKey pk = SSLTools.getPublicKeyFromPrivateKey(cleanedPem.getBytes(), null);
        String key = SSLTools.pemWriter(pk);
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        key = key.replace("\r", "");
        key = key.replace("\n", "");
        sb.append("p=").append(key);
        return sb.toString();
    }

    public static KeyPair generateKeyPair(int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
        keyGen.initialize(keysize, new SecureRandom());
        KeyPair keypair = keyGen.generateKeyPair();
        return keypair;
    }

    public static String cleanRSAPrivateKeyPem(String privateKeyText) {
        String privatePem = privateKeyText;
        String header = "-----BEGIN RSA PRIVATE KEY-----\n";
        String footer = "-----END RSA PRIVATE KEY-----\n";
        privatePem = privatePem.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("-----END RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("\n", "");
        StringBuilder sb = new StringBuilder();
        sb.append(header);
        for (int index = 0; index < privatePem.length(); index += 64) {
            sb.append(privatePem.substring(index, Math.min(index + 64, privatePem.length()))).append("\n");
        }
        sb.append(footer);
        return sb.toString();
    }

    private static PrivateKey generatePrivateKeyByPEM(String privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String privatePem = privateKey;
        privatePem = privatePem.replace("-----BEGIN RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("-----END RSA PRIVATE KEY-----", "");
        privatePem = privatePem.replace("\n", "");
        byte[] encoded = Base64.decode((String)privatePem);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    public static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String pemWriter(Object o) throws IOException {
        StringWriter sw = new StringWriter();
        PEMWriter pw = new PEMWriter((Writer)sw);
        pw.writeObject(o);
        pw.flush();
        return sw.toString();
    }

    public static Object pemReader(String pem) throws IOException {
        StringReader reader = new StringReader(pem);
        PEMReader pr = new PEMReader((Reader)reader);
        return pr.readObject();
    }
}

