/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnoPrincipalResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.CommonResource;
import io.milton.http.annotated.ResourceList;
import io.milton.http.annotated.scheduling.SchedulingInboxResource;
import io.milton.http.annotated.scheduling.SchedulingOutboxResource;
import io.milton.http.caldav.CalendarSearchService;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.Resource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnoCalendarHomeResource
extends AnnoCollectionResource {
    private static final Logger log = LoggerFactory.getLogger(AnnoCalendarHomeResource.class);
    private final AnnoPrincipalResource principal;
    private final CalendarSearchService calendarSearchService;
    private SchedulingInboxResource inboxResource;
    private SchedulingOutboxResource outboxResource;

    public AnnoCalendarHomeResource(AnnotationResourceFactory outer, Object source, AnnoPrincipalResource parent, CalendarSearchService calendarSearchService) {
        super(outer, source, parent);
        this.principal = parent;
        this.calendarSearchService = calendarSearchService;
    }

    @Override
    public List<? extends Resource> getChildren() throws NotAuthorizedException, BadRequestException {
        return this.getChildren(false);
    }

    @Override
    public List<? extends Resource> getChildren(boolean isChildLoopup) throws NotAuthorizedException, BadRequestException {
        ResourceList annoResources = this.findChildren(isChildLoopup);
        ArrayList<CommonResource> list = new ArrayList<CommonResource>(annoResources);
        list.add((CommonResource)((Object)this.inboxResource));
        list.add((CommonResource)((Object)this.outboxResource));
        return list;
    }

    @Override
    protected void initChildren(boolean isChildLookup) throws NotAuthorizedException, BadRequestException {
        super.initChildren(isChildLookup);
        this.inboxResource = new SchedulingInboxResource(this.principal, this.calendarSearchService, this.calendarSearchService.getSchedulingInboxColName());
        this.outboxResource = new SchedulingOutboxResource(this.principal, this.calendarSearchService, this.calendarSearchService.getSchedulingOutboxColName());
    }
}

