/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.annotated;

import io.milton.annotations.CTag;
import io.milton.http.Request;
import io.milton.http.annotated.AbstractAnnotationHandler;
import io.milton.http.annotated.AnnoCollectionResource;
import io.milton.http.annotated.AnnotationResourceFactory;
import io.milton.http.annotated.ControllerMethod;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.resource.CollectionResource;
import io.milton.resource.Resource;
import java.lang.reflect.Method;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CTagAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(CTagAnnotationHandler.class);
    private final String[] CTAG_PROP_NAMES = new String[]{"ctag"};

    public static String deriveCtag(CollectionResource col) throws NotAuthorizedException, BadRequestException {
        Date latest = col.getModifiedDate();
        for (Resource r : col.getChildren()) {
            Date d = r.getModifiedDate();
            if (d == null || latest != null && !d.after(latest)) continue;
            latest = d;
        }
        String ctag = null;
        if (latest != null) {
            ctag = "T" + latest.getTime();
        }
        return ctag;
    }

    public CTagAnnotationHandler(AnnotationResourceFactory outer) {
        super(outer, CTag.class, new Request.Method[0]);
    }

    public String execute(AnnoCollectionResource col) {
        Object source = col.getSource();
        try {
            Object rawId = null;
            ControllerMethod cm = this.getBestMethod(source.getClass());
            if (cm == null) {
                Method m = this.annoResourceFactory.findMethodForAnno(source.getClass(), this.annoClass);
                if (m != null) {
                    rawId = m.invoke(source, new Object[0]);
                    if (log.isDebugEnabled()) {
                        log.debug("Got ctag from source object. ctag=" + rawId);
                    }
                } else {
                    for (String nameProp : this.CTAG_PROP_NAMES) {
                        Object oPropVal;
                        if (!PropertyUtils.isReadable((Object)source, (String)nameProp)) continue;
                        rawId = oPropVal = PropertyUtils.getProperty((Object)source, (String)nameProp);
                        if (!log.isDebugEnabled()) break;
                        log.debug("Got ctag from bean property:" + nameProp + "  ctag=" + rawId);
                        break;
                    }
                    if (rawId == null) {
                        rawId = CTagAnnotationHandler.deriveCtag(col);
                        if (log.isInfoEnabled()) {
                            log.debug("Derived ctag from directory members. This is not recommended, you should implement an @CTag method. Ctag=" + rawId);
                        }
                    }
                }
            } else {
                rawId = cm.method.invoke(cm.controller, source);
                if (log.isDebugEnabled()) {
                    log.debug("Got ctag from annotated method. ctag=" + rawId);
                }
            }
            if (rawId != null) {
                String s = rawId.toString();
                if (s.length() == 0) {
                    log.warn("CTAG value is blank");
                }
                return s;
            }
            log.warn("CTAG value is null");
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception executing " + this.getClass() + " - " + source.getClass(), e);
        }
    }
}

