/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.entity;

import io.milton.common.BufferingOutputStream;
import io.milton.http.Range;
import io.milton.http.Response;
import io.milton.http.http11.MultipleRangeWritingOutputStream;
import io.milton.resource.GetableResource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialEntity
implements Response.Entity {
    private static final Logger log = LoggerFactory.getLogger(PartialEntity.class);
    private final GetableResource resource;
    private final List<Range> ranges;
    private final Map<String, String> params;
    private final String contentType;
    private final String multipartBoundary;

    public PartialEntity(GetableResource resource, List<Range> ranges, Map<String, String> params, String contentType, String multipartBoundary) {
        this.resource = resource;
        this.ranges = ranges;
        this.params = params;
        this.contentType = contentType;
        this.multipartBoundary = multipartBoundary;
    }

    public GetableResource getResource() {
        return this.resource;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void write(Response response, OutputStream outputStream) throws Exception {
        Long contentLength = this.resource.getContentLength();
        if (contentLength == null) {
            log.warn("Couldnt calculate range end position because the resource is not reporting a content length, and no end position was requested by the client: " + this.resource.getName() + " - " + this.resource.getClass());
            contentLength = -1L;
        }
        try {
            BufferingOutputStream bufOut = new BufferingOutputStream(100000);
            MultipleRangeWritingOutputStream multiOut = new MultipleRangeWritingOutputStream(contentLength, (OutputStream)bufOut, this.ranges, this.multipartBoundary, this.contentType);
            this.resource.sendContent((OutputStream)multiOut, null, this.params, this.contentType);
            response.setContentLengthHeader(Long.valueOf(bufOut.getSize()));
            IOUtils.copy((InputStream)bufOut.getInputStream(), (OutputStream)outputStream);
        }
        catch (IOException ex) {
            log.warn("IOException writing response: " + ex.getMessage());
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }
}

