/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.http11.auth;

import io.milton.http.AuthenticationHandler;
import io.milton.http.Request;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.http11.auth.NonceProvider;
import io.milton.http.http11.auth.OAuth2Helper;
import io.milton.http.values.Pair;
import io.milton.resource.OAuth2Provider;
import io.milton.resource.OAuth2Resource;
import io.milton.resource.Resource;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.client.response.OAuthAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthenticationHandler
implements AuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthenticationHandler.class);
    public static final String REQ_ATT_LOCAL_USER = "_oauthLocalUser";
    public static final String REQ_ATT_OAUTH_DETAILS = "_oauthDetails";
    public static final String REQ_ATT_OAUTH_JSON = "_oauthJson";
    private final NonceProvider nonceProvider;
    private final OAuth2Helper oAuth2Helper;

    public static Object getFoundLocalUser(Request r) {
        return r.getAttributes().get(REQ_ATT_LOCAL_USER);
    }

    public static OAuth2Resource.OAuth2ProfileDetails getOAuthDetails(Request r) {
        return (OAuth2Resource.OAuth2ProfileDetails)r.getAttributes().get(REQ_ATT_OAUTH_DETAILS);
    }

    public static String getOAuthDetailsJson(Request r) {
        return (String)r.getAttributes().get(REQ_ATT_OAUTH_JSON);
    }

    public OAuth2AuthenticationHandler(NonceProvider nonceProvider) {
        this.nonceProvider = nonceProvider;
        this.oAuth2Helper = new OAuth2Helper(nonceProvider);
    }

    @Override
    public Object authenticate(Resource resource, Request request) {
        if (request == null) {
            return null;
        }
        return OAuth2AuthenticationHandler.getFoundLocalUser(request);
    }

    @Override
    public boolean supports(Resource r, Request request) {
        log.trace("supports");
        if (request == null || request.getParams() == null) {
            return false;
        }
        String oAuth2Code = (String)request.getParams().get("code");
        if (StringUtils.isBlank((String)oAuth2Code)) {
            return false;
        }
        try {
            if (r instanceof OAuth2Resource) {
                OAuth2Resource oAuth2Resource = (OAuth2Resource)r;
                log.info("This is a OAuth2Resource {} ", (Object)oAuth2Resource);
                OAuth2Resource.OAuth2ProfileDetails oAuth2TokenUser = this.parse(oAuth2Resource, request);
                if (oAuth2TokenUser == null) {
                    log.warn("Failed to convert oauth2 response to profile");
                    return false;
                }
                log.info("oauth2 login {}", (Object)oAuth2TokenUser);
                request.getAttributes().put(REQ_ATT_OAUTH_DETAILS, oAuth2TokenUser);
                Object localUser = oAuth2Resource.authenticate(oAuth2TokenUser);
                if (localUser == null) {
                    log.info("No local user, cannot authenticate");
                    return false;
                }
                request.getAttributes().put(REQ_ATT_LOCAL_USER, localUser);
                return true;
            }
            log.info("Cannot authenticate resource which does not implement OAuth2Resource - {}", r.getClass());
            return false;
        }
        catch (Exception ex) {
            log.error("OAuth2 Authentication Handler error. ", (Throwable)ex);
            return false;
        }
    }

    @Override
    public void appendChallenges(Resource resource, Request request, List<String> challenges) {
    }

    @Override
    public boolean isCompatible(Resource resource, Request request) {
        return request != null && request instanceof Request;
    }

    @Override
    public boolean credentialsPresent(Request request) {
        return true;
    }

    public OAuth2Resource.OAuth2ProfileDetails parse(OAuth2Resource oAuth2Resource, Request request) throws BadRequestException, OAuthSystemException, OAuthProblemException {
        if (request == null) {
            return null;
        }
        log.info("This is a OAuth2Resource{} " + oAuth2Resource);
        String oAuth2Code = (String)request.getParams().get("code");
        String oAuth2Error = (String)request.getParams().get("error");
        log.info("authenticate(), error{}" + oAuth2Error + " oAuth2Code{}" + oAuth2Code);
        if (StringUtils.isNotBlank((String)oAuth2Code) && StringUtils.isBlank((String)oAuth2Error)) {
            String state = (String)request.getParams().get("state");
            Pair<String, String> statePair = OAuth2Helper.parseState(state);
            String provId = (String)statePair.getObject1();
            String returnUrl = (String)statePair.getObject2();
            if (StringUtils.isBlank((String)provId)) {
                log.warn("Could not authenticate oauth2 response because there is no provider ID parameter in the state parameter");
                return null;
            }
            OAuth2Provider prov = (OAuth2Provider)oAuth2Resource.getOAuth2Providers().get(provId);
            if (prov == null) {
                log.warn("Could not authenticate oauth2 response because couldnt find provider: " + provId);
                return null;
            }
            OAuthAccessTokenResponse oAuth2Response = this.oAuth2Helper.obtainAuth2Token(prov, oAuth2Code);
            log.info("This is a OAuth2TokenResponse{} " + oAuth2Response);
            if (oAuth2Response != null) {
                OAuthResourceResponse resourceResponse = this.oAuth2Helper.getOAuth2Profile(oAuth2Response, prov);
                log.info("This is a OAuthResourceResponse{} " + resourceResponse);
                if (resourceResponse != null) {
                    OAuth2Resource.OAuth2ProfileDetails oAuth2TokenUser = this.oAuth2Helper.getOAuth2UserInfo(request, resourceResponse, oAuth2Response, prov, oAuth2Code, returnUrl);
                    return oAuth2TokenUser;
                }
            }
        }
        return null;
    }
}

