/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.Path;
import io.milton.common.Utils;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.CopyableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(CopyJsonResource.class);
    private final String host;
    private final ResourceFactory resourceFactory;
    private final CopyableResource wrapped;

    public CopyJsonResource(String host, CopyableResource copyableResource, ResourceFactory resourceFactory) {
        super((Resource)copyableResource, Request.Method.COPY.code, null);
        this.host = host;
        this.wrapped = copyableResource;
        this.resourceFactory = resourceFactory;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException {
        String destHeader = parameters.get("destination");
        String dest = Utils.decodePath((String)destHeader);
        Path pDest = Path.path((String)dest);
        Resource rDestParent = this.resourceFactory.getResource(this.host, pDest.getParent().toString());
        if (rDestParent == null) {
            throw new BadRequestException((Resource)this.wrapped, "The destination parent does not exist");
        }
        if (rDestParent instanceof CollectionResource) {
            CollectionResource colDestParent = (CollectionResource)rDestParent;
            if (colDestParent.child(pDest.getName()) == null) {
                try {
                    this.wrapped.copyTo(colDestParent, pDest.getName());
                }
                catch (ConflictException ex) {
                    log.warn("Exception copying to: " + pDest.getName(), (Throwable)ex);
                    throw new BadRequestException(rDestParent, "conflict: " + ex.getMessage());
                }
                return null;
            }
            log.warn("destination already exists: " + pDest.getName());
            throw new BadRequestException(rDestParent, "File already exists");
        }
        throw new BadRequestException((Resource)this.wrapped, "The destination parent is not a collection resource");
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.COPY;
    }
}

