/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.json;

import io.milton.common.Path;
import io.milton.http.FileItem;
import io.milton.http.Range;
import io.milton.http.Request;
import io.milton.http.ResourceFactory;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.json.JsonResource;
import io.milton.resource.CollectionResource;
import io.milton.resource.MoveableResource;
import io.milton.resource.PostableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveJsonResource
extends JsonResource
implements PostableResource {
    private static final Logger log = LoggerFactory.getLogger(MoveJsonResource.class);
    private final String host;
    private final ResourceFactory resourceFactory;
    private final MoveableResource wrapped;

    public MoveJsonResource(String host, MoveableResource copyableResource, ResourceFactory resourceFactory) {
        super((Resource)copyableResource, Request.Method.COPY.code, null);
        this.host = host;
        this.wrapped = copyableResource;
        this.resourceFactory = resourceFactory;
    }

    public String processForm(Map<String, String> parameters, Map<String, FileItem> files) throws BadRequestException, NotAuthorizedException {
        Resource rDestParent;
        String dest = parameters.get("destination");
        if (dest == null) {
            throw new BadRequestException((Resource)this, "The destination parameter is null");
        }
        if (dest.trim().length() == 0) {
            throw new BadRequestException((Resource)this, "The destination parameter is empty");
        }
        Path pDest = Path.path((String)dest);
        if (pDest == null) {
            throw new BadRequestException((Resource)this, "Couldnt parse the destination header, returned null from: " + dest);
        }
        String parentPath = "/";
        if (pDest.getParent() != null) {
            parentPath = pDest.getParent().toString();
        }
        if ((rDestParent = this.resourceFactory.getResource(this.host, parentPath)) == null) {
            throw new BadRequestException((Resource)this.wrapped, "The destination parent does not exist");
        }
        if (rDestParent instanceof CollectionResource) {
            CollectionResource colDestParent = (CollectionResource)rDestParent;
            if (colDestParent.child(pDest.getName()) == null) {
                try {
                    this.wrapped.moveTo(colDestParent, pDest.getName());
                }
                catch (ConflictException ex) {
                    log.warn("Exception copying to: " + pDest.getName(), (Throwable)ex);
                    throw new BadRequestException(rDestParent, "conflict: " + ex.getMessage());
                }
                return null;
            }
            log.warn("destination already exists: " + pDest.getName() + " in folder: " + colDestParent.getName());
            throw new BadRequestException(rDestParent, "File already exists");
        }
        throw new BadRequestException((Resource)this.wrapped, "The destination parent is not a collection resource");
    }

    public void sendContent(OutputStream out, Range range, Map<String, String> params, String contentType) throws IOException, NotAuthorizedException, BadRequestException {
    }

    @Override
    public Request.Method applicableMethod() {
        return Request.Method.MOVE;
    }
}

