/*
 * Decompiled with CFR 0.152.
 */
package io.milton.http.report;

import io.milton.common.ReadingException;
import io.milton.common.WritingException;
import io.milton.http.ExistingEntityHandler;
import io.milton.http.HttpManager;
import io.milton.http.Request;
import io.milton.http.ResourceHandlerHelper;
import io.milton.http.Response;
import io.milton.http.entity.ByteArrayEntity;
import io.milton.http.exceptions.BadRequestException;
import io.milton.http.exceptions.ConflictException;
import io.milton.http.exceptions.NotAuthorizedException;
import io.milton.http.report.Report;
import io.milton.http.webdav.WebDavResponseHandler;
import io.milton.resource.ReportableResource;
import io.milton.resource.Resource;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportHandler
implements ExistingEntityHandler {
    private final Logger log = LoggerFactory.getLogger(ReportHandler.class);
    private final WebDavResponseHandler responseHandler;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final Map<String, Report> reports;

    public ReportHandler(WebDavResponseHandler responseHandler, ResourceHandlerHelper resourceHandlerHelper, Map<String, Report> reports) {
        this.responseHandler = responseHandler;
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.reports = reports;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.REPORT.code};
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        this.resourceHandlerHelper.processResource(manager, request, response, r, this);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document doc = builder.build(request.getInputStream());
            String reportName = doc.getRootElement().getName();
            Report r = this.reports.get(reportName);
            if (r == null) {
                this.log.error("report not known: " + reportName);
                throw new BadRequestException(resource);
            }
            this.log.info("process report: " + reportName + " with : " + r.getClass());
            String xml = r.process(request.getHostHeader(), request.getAbsolutePath(), resource, doc);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Report XML:\n" + xml);
            }
            response.setStatus(Response.Status.SC_MULTI_STATUS);
            response.setContentTypeHeader("text/xml");
            response.setEntity((Response.Entity)new ByteArrayEntity(xml.getBytes("UTF-8")));
        }
        catch (JDOMException ex) {
            java.util.logging.Logger.getLogger(ReportHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isCompatible(Resource res) {
        return res instanceof ReportableResource;
    }
}

