/*
 * Decompiled with CFR 0.152.
 */
package io.milton.ldap;

import io.milton.common.LogUtils;
import io.milton.http.exceptions.BadRequestException;
import io.milton.ldap.Condition;
import io.milton.ldap.LdapPropertyMapper;
import io.milton.resource.LdapContact;
import io.milton.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(AttributeCondition.class);
    private final LdapPropertyMapper propertyMapper;
    private final String attributeName;
    private final Condition.Operator operator;
    private final String value;
    private boolean isIntValue;

    public AttributeCondition(LdapPropertyMapper propertyMapper, String attributeName, Condition.Operator operator, String value) {
        this.propertyMapper = propertyMapper;
        this.attributeName = attributeName;
        this.operator = operator;
        this.value = value;
    }

    public AttributeCondition(LdapPropertyMapper propertyMapper, String attributeName, Condition.Operator operator, int value) {
        this(propertyMapper, attributeName, operator, String.valueOf(value));
        this.isIntValue = true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isMatch(LdapContact contact) throws BadRequestException {
        String lowerCaseValue = this.value.toLowerCase();
        String actualValue = this.propertyMapper.getLdapPropertyValue(this.attributeName, (Resource)contact);
        Condition.Operator actualOperator = this.operator;
        if (actualValue == null && ("givenName".equals(this.attributeName) || "sn".equals(this.attributeName))) {
            actualValue = this.propertyMapper.getLdapPropertyValue("cn", (Resource)contact);
            actualOperator = Condition.Operator.Like;
        }
        if (actualValue == null) {
            return false;
        }
        actualValue = actualValue.toLowerCase();
        boolean b = actualOperator == Condition.Operator.IsEqualTo && actualValue.equals(lowerCaseValue) || actualOperator == Condition.Operator.Like && actualValue.contains(lowerCaseValue) || actualOperator == Condition.Operator.StartsWith && actualValue.startsWith(lowerCaseValue);
        LogUtils.trace((Logger)log, (Object[])new Object[]{"isMatch: result:", b, "attributeName:", this.attributeName, "operator:", actualOperator, "test value", actualValue, "query value", lowerCaseValue});
        return b;
    }
}

