/*
 * Decompiled with CFR 0.152.
 */
package io.milton.property;

import io.milton.http.Request;
import io.milton.http.Response;
import io.milton.property.PropertyAuthoriser;
import io.milton.resource.Resource;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPropertyAuthoriser
implements PropertyAuthoriser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropertyAuthoriser.class);

    @Override
    public Set<PropertyAuthoriser.CheckResult> checkPermissions(Request request, Request.Method method, PropertyAuthoriser.PropertyPermission perm, Set<QName> fields, Resource resource) {
        if (resource.authorise(request, request.getMethod(), request.getAuthorization())) {
            log.trace("checkPermissions: ok");
            return null;
        }
        log.info("checkPermissions: property authorisation failed because user does not have permission for method: " + method.code);
        HashSet<PropertyAuthoriser.CheckResult> set = new HashSet<PropertyAuthoriser.CheckResult>();
        for (QName name : fields) {
            set.add(new PropertyAuthoriser.CheckResult(name, Response.Status.SC_UNAUTHORIZED, "Not authorised", resource));
        }
        return set;
    }
}

