/*
 * Decompiled with CFR 0.152.
 */
package io.milton.servlet;

import io.milton.http.HttpManager;
import io.milton.servlet.DefaultMiltonConfigurator;
import io.milton.servlet.MiltonConfigurator;
import io.milton.servlet.ServletConfigWrapper;
import io.milton.servlet.ServletRequest;
import io.milton.servlet.ServletResponse;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiltonServlet
implements Servlet {
    private final Logger log = LoggerFactory.getLogger(MiltonServlet.class);
    private static final ThreadLocal<HttpServletRequest> originalRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> originalResponse = new ThreadLocal();
    private static final ThreadLocal<ServletConfig> tlServletConfig = new ThreadLocal();
    private ServletConfigWrapper config;
    private ServletContext servletContext;
    protected HttpManager httpManager;
    protected MiltonConfigurator configurator;

    public static HttpServletRequest request() {
        return originalRequest.get();
    }

    public static HttpServletResponse response() {
        return originalResponse.get();
    }

    public static ServletConfig servletConfig() {
        return tlServletConfig.get();
    }

    public static void forward(String url) {
        try {
            MiltonServlet.request().getRequestDispatcher(url).forward((javax.servlet.ServletRequest)originalRequest.get(), (javax.servlet.ServletResponse)originalResponse.get());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.config = new ServletConfigWrapper(config);
            this.servletContext = config.getServletContext();
            String configuratorClassName = config.getInitParameter("milton.configurator");
            this.configurator = configuratorClassName != null ? (MiltonConfigurator)DefaultMiltonConfigurator.instantiate(configuratorClassName) : new DefaultMiltonConfigurator();
            this.httpManager = this.configurator.configure(this.config);
        }
        catch (ServletException ex) {
            this.log.error("Exception starting milton servlet", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.log.error("Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        this.log.debug("destroy");
        if (this.configurator == null) {
            return;
        }
        this.configurator.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            MiltonServlet.setThreadlocals(req, resp);
            tlServletConfig.set(this.config.getServletConfig());
            ServletRequest request = new ServletRequest(req, this.servletContext);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            MiltonServlet.clearThreadlocals();
            tlServletConfig.remove();
            ServletRequest.clearThreadLocals();
            servletResponse.getOutputStream().flush();
            servletResponse.flushBuffer();
        }
    }

    public static void clearThreadlocals() {
        originalRequest.remove();
        originalResponse.remove();
    }

    public static void setThreadlocals(HttpServletRequest req, HttpServletResponse resp) {
        originalRequest.set(req);
        originalResponse.set(resp);
    }

    public String getServletInfo() {
        return "MiltonServlet";
    }

    public ServletConfig getServletConfig() {
        return this.config.getServletConfig();
    }
}

