/*
 * Decompiled with CFR 0.152.
 */
package io.milton.simpleton;

import io.milton.http.AbstractResponse;
import io.milton.http.Cookie;
import io.milton.http.Response;
import io.milton.simpleton.SimpletonCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMiltonResponse
extends AbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(SimpleMiltonResponse.class);
    public final Response baseResponse;
    public final long started;
    public boolean disableClose;
    private final Map<String, String> headers = new HashMap<String, String>();
    private Response.Status status;

    public SimpleMiltonResponse(Response baseResponse) {
        this.baseResponse = baseResponse;
        this.started = System.currentTimeMillis();
    }

    @Override
    public void setContentLengthHeader(Long totalLength) {
        if (totalLength != null) {
            int i = (int)totalLength.longValue();
            this.baseResponse.setContentLength(i);
        }
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public void setStatus(Response.Status status) {
        this.status = status;
        this.baseResponse.setCode(status.code);
    }

    public void setNonStandardHeader(String code, String value) {
        this.headers.put(code, value);
        this.baseResponse.set(code, value);
    }

    public String getNonStandardHeader(String code) {
        return this.baseResponse.getValue(code);
    }

    public OutputStream getOutputStream() {
        try {
            return this.baseResponse.getOutputStream();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        if (this.disableClose) {
            return;
        }
        try {
            this.baseResponse.close();
            log.debug("request completed in: " + (System.currentTimeMillis() - this.started));
        }
        catch (Exception ex) {
            log.error("exception closing response", (Throwable)ex);
        }
    }

    public void closeReally() {
        try {
            this.baseResponse.close();
            if (log.isInfoEnabled()) {
                log.info("request completed in: " + (System.currentTimeMillis() - this.started));
            }
        }
        catch (Throwable ex) {
            log.error("exception closing", ex);
        }
    }

    @Override
    public void setLocationHeader(String arg0) {
        super.setLocationHeader(arg0);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setAuthenticateHeader(List<String> challenges) {
        for (String ch : challenges) {
            this.baseResponse.add(Response.Header.WWW_AUTHENTICATE.code, ch);
        }
    }

    public Cookie setCookie(Cookie cookie) {
        if (cookie instanceof SimpletonCookie) {
            SimpletonCookie sc = (SimpletonCookie)cookie;
            this.baseResponse.setCookie(sc.getWrapped());
            return cookie;
        }
        org.simpleframework.http.Cookie c = new org.simpleframework.http.Cookie(cookie.getName(), cookie.getValue());
        c.setDomain(cookie.getDomain());
        c.setExpiry(cookie.getExpiry());
        c.setPath(cookie.getPath());
        c.setSecure(cookie.getSecure());
        c.setVersion(cookie.getVersion());
        this.baseResponse.setCookie(c);
        return new SimpletonCookie(c);
    }

    public Cookie setCookie(String name, String value) {
        org.simpleframework.http.Cookie c = this.baseResponse.setCookie(name, value);
        return new SimpletonCookie(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendError(Response.Status status, String message) {
        try {
            this.setStatus(status);
            this.getOutputStream().write(message.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            log.error("Exception sending error", (Throwable)iOException);
        }
        finally {
            this.closeReally();
        }
    }
}

