/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictCompress;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdOutputStreamNoFinalizer
extends FilterOutputStream {
    private final long stream = ZstdOutputStreamNoFinalizer.createCStream();
    private long srcPos = 0L;
    private long dstPos = 0L;
    private final BufferPool bufferPool;
    private final ByteBuffer dstByteBuffer;
    private final byte[] dst;
    private boolean isClosed = false;
    private static final int dstSize;
    private boolean closeFrameOnFlush = false;
    private boolean frameClosed = true;
    private boolean frameStarted = false;

    public static native long recommendedCOutSize();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private native int resetCStream(long var1);

    private native int compressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native int flushStream(long var1, byte[] var3, int var4);

    private native int endStream(long var1, byte[] var3, int var4);

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, int n2) throws IOException {
        this(outputStream, NoPool.INSTANCE);
        Zstd.setCompressionLevel(this.stream, n2);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream) throws IOException {
        this(outputStream, NoPool.INSTANCE);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, BufferPool bufferPool, int n2) throws IOException {
        this(outputStream, bufferPool);
        Zstd.setCompressionLevel(this.stream, n2);
    }

    public ZstdOutputStreamNoFinalizer(OutputStream outputStream, BufferPool bufferPool) throws IOException {
        super(outputStream);
        this.bufferPool = bufferPool;
        this.dstByteBuffer = bufferPool.get(dstSize);
        if (this.dstByteBuffer == null) {
            throw new ZstdIOException(Zstd.errMemoryAllocation(), "Cannot get ByteBuffer of size " + dstSize + " from the BufferPool");
        }
        this.dst = Zstd.extractArray(this.dstByteBuffer);
    }

    public synchronized ZstdOutputStreamNoFinalizer setChecksum(boolean bl) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n2 = Zstd.setCompressionChecksums(this.stream, bl);
        if (Zstd.isError(n2)) {
            throw new ZstdIOException(n2);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setLevel(int n2) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n3 = Zstd.setCompressionLevel(this.stream, n2);
        if (Zstd.isError(n3)) {
            throw new ZstdIOException(n3);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setLong(int n2) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n3 = Zstd.setCompressionLong(this.stream, n2);
        if (Zstd.isError(n3)) {
            throw new ZstdIOException(n3);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setWorkers(int n2) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n3 = Zstd.setCompressionWorkers(this.stream, n2);
        if (Zstd.isError(n3)) {
            throw new ZstdIOException(n3);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setCloseFrameOnFlush(boolean bl) {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        this.closeFrameOnFlush = bl;
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(byte[] byArray) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n2 = Zstd.loadDictCompress(this.stream, byArray, byArray.length);
        if (Zstd.isError(n2)) {
            throw new ZstdIOException(n2);
        }
        return this;
    }

    public synchronized ZstdOutputStreamNoFinalizer setDict(ZstdDictCompress zstdDictCompress) throws IOException {
        if (!this.frameClosed) {
            throw new IllegalStateException("Change of parameter on initialized stream");
        }
        int n2 = Zstd.loadFastDictCompress(this.stream, zstdDictCompress);
        if (Zstd.isError(n2)) {
            throw new ZstdIOException(n2);
        }
        return this;
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.isClosed) {
            throw new IOException("StreamClosed");
        }
        if (this.frameClosed) {
            n4 = this.resetCStream(this.stream);
            if (Zstd.isError(n4)) {
                throw new ZstdIOException(n4);
            }
            this.frameClosed = false;
            this.frameStarted = true;
        }
        n4 = n2 + n3;
        this.srcPos = n2;
        while (this.srcPos < (long)n4) {
            int n5 = this.compressStream(this.stream, this.dst, dstSize, byArray, n4);
            if (Zstd.isError(n5)) {
                throw new ZstdIOException(n5);
            }
            if (this.dstPos <= 0L) continue;
            this.out.write(this.dst, 0, (int)this.dstPos);
        }
    }

    @Override
    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)n2};
        this.write(byArray, 0, 1);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("StreamClosed");
        }
        if (!this.frameClosed) {
            if (this.closeFrameOnFlush) {
                int n2;
                do {
                    if (Zstd.isError(n2 = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n2);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n2 > 0);
                this.frameClosed = true;
            } else {
                int n3;
                do {
                    if (Zstd.isError(n3 = this.flushStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n3);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n3 > 0);
            }
            this.out.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(true);
    }

    public synchronized void closeWithoutClosingParentStream() throws IOException {
        this.close(false);
    }

    private void close(boolean bl) throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            int n2;
            if (!this.frameStarted) {
                n2 = this.resetCStream(this.stream);
                if (Zstd.isError(n2)) {
                    throw new ZstdIOException(n2);
                }
                this.frameClosed = false;
            }
            if (!this.frameClosed) {
                do {
                    if (Zstd.isError(n2 = this.endStream(this.stream, this.dst, dstSize))) {
                        throw new ZstdIOException(n2);
                    }
                    this.out.write(this.dst, 0, (int)this.dstPos);
                } while (n2 > 0);
            }
            if (bl) {
                this.out.close();
            }
        }
        finally {
            this.isClosed = true;
            this.bufferPool.release(this.dstByteBuffer);
            ZstdOutputStreamNoFinalizer.freeCStream(this.stream);
        }
    }

    static {
        Native.load();
        dstSize = (int)ZstdOutputStreamNoFinalizer.recommendedCOutSize();
    }
}

