/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.JavaTypeVariants;
import io.moderne.serialization.a;
import io.moderne.serialization.b.t;
import io.moderne.serialization.b.u;
import io.moderne.serialization.r;
import io.moderne.serialization.s;
import io.moderne.serialization.x;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.style.Autodetect;

public class TreeSerializer {
    private final ObjectMapper a;
    private final MeterRegistry b;

    public TreeSerializer() {
        this((MeterRegistry)new SimpleMeterRegistry(), null, true);
    }

    public TreeSerializer(boolean bl) {
        this((MeterRegistry)new SimpleMeterRegistry(), null, bl);
    }

    public TreeSerializer(MeterRegistry object, @Nullable ClassLoader classLoader, boolean bl) {
        this.b = object;
        boolean bl2 = bl;
        object = classLoader;
        SmileFactory smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
        smileFactory = JsonMapper.builder((JsonFactory)smileFactory);
        ObjectMapper objectMapper = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)smileFactory.constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).disable(new MapperFeature[]{MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES})).build()).registerModule((Module)new io.moderne.serialization.u()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new io.moderne.serialization.a.a(bl2)).registerModule((Module)new x()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new s(0)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.coercionConfigFor(LogicalType.Collection).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull).setAcceptBlankAsEmpty(Boolean.TRUE);
        if (object != null) {
            objectMapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader((ClassLoader)object));
        }
        ObjectMapper objectMapper2 = objectMapper;
        this.a = objectMapper2.setVisibility(objectMapper2.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public List<SourceFile> read(InputStream inputStream) {
        List<SourceFile> list;
        block8: {
            inputStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
            try {
                List<SourceFile> list2 = (List<SourceFile>)this.a.readValue(inputStream, (TypeReference)new r(this));
                list2 = new t().a(list2);
                Counter.builder((String)"moderne.ast.load").tags(new String[]{"outcome", "success"}).register(this.b).increment();
                list = list2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    Counter.builder((String)"moderne.ast.load").tags(new String[]{"outcome", "failure", "exception", throwable3.getClass().getName()}).register(this.b).increment();
                    throw throwable3;
                }
            }
            inputStream.close();
        }
        return list;
    }

    public List<File> write(Stream<SourceFile> stream, Path path, CompressionAlgorithm ... compressionAlgorithmArray) {
        return this.write(stream, path, () -> UUID.randomUUID() + ".lst", compressionAlgorithmArray);
    }

    public List<File> write(Stream<SourceFile> stream, Path path, Supplier<String> supplier, CompressionAlgorithm ... compressionAlgorithmArray) {
        if (!Files.exists(path, new LinkOption[0]) && !path.toFile().mkdirs()) {
            throw new UncheckedIOException(new IOException("Unable to write LSTs to " + path));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        Autodetect.Detector detector = Autodetect.detector();
        Autodetect.Detector detector2 = org.openrewrite.xml.style.Autodetect.detector();
        stream.peek(arg_0 -> ((Autodetect.Detector)detector).sample(arg_0)).peek(arg_0 -> ((Autodetect.Detector)detector2).sample(arg_0)).collect(new a(200, list2 -> {
            path = path.resolve((String)supplier.get()).toFile();
            try {
                this.write((List<SourceFile>)list2, null, (File)((Object)path), compressionAlgorithmArray);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            arrayList.add((File)((Object)path));
        }));
        this.writeStyles((NamedStyles)detector.build(), path);
        this.writeStyles((NamedStyles)detector2.build(), path);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(List<SourceFile> list, @Nullable JavaTypeVariants object, File object2, CompressionAlgorithm ... object3) {
        object = new u((JavaTypeVariants)object);
        if (list.size() > 200) {
            throw new IllegalArgumentException("Use write(Stream, Path, ..) instead.");
        }
        object2 = Files.newOutputStream(((File)object2).toPath(), new OpenOption[0]);
        try {
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);){
                object3 = CompressionAlgorithm.compressor((CompressionAlgorithm[])object3, bufferedOutputStream);
                try {
                    list = ((u)object).a(list);
                    this.a.writeValue((OutputStream)object3, list);
                }
                finally {
                    if (object3 != null) {
                        ((OutputStream)object3).close();
                    }
                }
            }
            if (object2 == null) return;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((OutputStream)object2).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object2).close();
    }

    public void writeStyles(NamedStyles namedStyles, Path comparable) {
        comparable = comparable.resolve(namedStyles.getName() + ".styles").toFile();
        try {
            this.a.writeValue((File)comparable, (Object)namedStyles);
            return;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public NamedStyles readStyles(File file) {
        try {
            return (NamedStyles)this.a.readValue(file, NamedStyles.class);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public ObjectMapper getMapper() {
        return this.a;
    }
}

