/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BytesAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import io.opentelemetry.extension.incubator.logs.AnyValue;
import java.nio.ByteBuffer;
import java.util.List;

public final class AnyValueMarshaler {
    private AnyValueMarshaler() {
    }

    public static MarshalerWithSize create(AnyValue<?> anyValue) {
        switch (anyValue.getType()) {
            case STRING: {
                return StringAnyValueMarshaler.create((String)anyValue.getValue());
            }
            case BOOLEAN: {
                return BoolAnyValueMarshaler.create((Boolean)anyValue.getValue());
            }
            case LONG: {
                return IntAnyValueMarshaler.create((Long)anyValue.getValue());
            }
            case DOUBLE: {
                return DoubleAnyValueMarshaler.create((Double)anyValue.getValue());
            }
            case ARRAY: {
                return ArrayAnyValueMarshaler.createAnyValue((List)anyValue.getValue());
            }
            case KEY_VALUE_LIST: {
                return KeyValueListAnyValueMarshaler.create((List)anyValue.getValue());
            }
            case BYTES: {
                return BytesAnyValueMarshaler.create((ByteBuffer)anyValue.getValue());
            }
        }
        throw new IllegalArgumentException("Unsupported AnyValue type: " + anyValue.getType());
    }
}

