/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.solr;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;

class SolrTracingUtils {
    SolrTracingUtils() {
    }

    static void onResponse(Span span, HttpResponse response) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getStatusLine().getStatusCode()));
    }

    static void onError(Span span, Exception e) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(SolrTracingUtils.errorLogs(e));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

