/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.solr;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.solr.HttpHeadersInjectAdapter;
import io.opentracing.contrib.solr.SolrTracingUtils;
import io.opentracing.contrib.solr.TracingResponseHandler;
import io.opentracing.noop.NoopSpan;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.io.Closeable;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class TracingHttpClient
implements HttpClient,
Closeable {
    static final String COMPONENT_NAME = "java-solr";
    private final HttpClient httpClient;
    private final Tracer tracer;
    private final boolean skipStatusAction;

    public TracingHttpClient(HttpClient httpClient, boolean skipStatusAction) {
        this(httpClient, GlobalTracer.get(), skipStatusAction);
    }

    public TracingHttpClient(HttpClient httpClient) {
        this(httpClient, false);
    }

    public TracingHttpClient(HttpClient httpClient, Tracer tracer) {
        this(httpClient, tracer, false);
    }

    public TracingHttpClient(HttpClient httpClient, Tracer tracer, boolean skipStatusAction) {
        this.httpClient = httpClient;
        this.tracer = tracer;
        this.skipStatusAction = skipStatusAction;
    }

    @Deprecated
    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        Span span = this.buildSpan((HttpRequest)request);
        try {
            HttpResponse response = this.httpClient.execute(request);
            SolrTracingUtils.onResponse(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (Exception e) {
            SolrTracingUtils.onError(span, e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Span span = this.buildSpan((HttpRequest)request);
        try {
            HttpResponse response = this.httpClient.execute(request, context);
            SolrTracingUtils.onResponse(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (Exception e) {
            SolrTracingUtils.onError(span, e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        Span span = this.buildSpan(request);
        try {
            HttpResponse response = this.httpClient.execute(target, request);
            SolrTracingUtils.onResponse(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (Exception e) {
            SolrTracingUtils.onError(span, e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Span span = this.buildSpan(request);
        try {
            HttpResponse response = this.httpClient.execute(target, request, context);
            SolrTracingUtils.onResponse(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (Exception e) {
            SolrTracingUtils.onError(span, e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Span span = this.buildSpan((HttpRequest)request);
        try {
            Object object = this.httpClient.execute(request, new TracingResponseHandler<T>(responseHandler, span, this.tracer));
            return (T)object;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Span span = this.buildSpan((HttpRequest)request);
        try {
            Object object = this.httpClient.execute(request, new TracingResponseHandler<T>(responseHandler, span, this.tracer), context);
            return (T)object;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Span span = this.buildSpan(request);
        try {
            Object object = this.httpClient.execute(target, request, new TracingResponseHandler<T>(responseHandler, span, this.tracer));
            return (T)object;
        }
        finally {
            span.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Span span = this.buildSpan(request);
        try {
            Object object = this.httpClient.execute(target, request, new TracingResponseHandler<T>(responseHandler, span, this.tracer), context);
            return (T)object;
        }
        finally {
            span.finish();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient instanceof Closeable) {
            ((Closeable)this.httpClient).close();
        }
    }

    private Span buildSpan(HttpRequest request) {
        String url = request.getRequestLine().getUri();
        if (this.skipStatusAction && url.contains("action=CLUSTERSTATUS")) {
            return NoopSpan.INSTANCE;
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(request.getRequestLine().getMethod()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME).withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.HTTP_URL.getKey(), url);
        Span span = spanBuilder.start();
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersInjectAdapter(request));
        return span;
    }
}

