/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.solr;

import io.opentracing.Tracer;
import io.opentracing.contrib.solr.TracingHttpClient;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;

public class TracingHttpSolrClientBuilder
extends HttpSolrClient.Builder {
    private final Tracer tracer;

    public TracingHttpSolrClientBuilder() {
        this.tracer = GlobalTracer.get();
    }

    public TracingHttpSolrClientBuilder(Tracer tracer) {
        this.tracer = tracer;
    }

    public TracingHttpSolrClientBuilder(String baseSolrUrl, Tracer tracer) {
        super(baseSolrUrl);
        this.tracer = tracer;
    }

    public HttpSolrClient build() {
        HttpSolrClient client = super.build();
        HttpClient httpClient = client.getHttpClient();
        super.withHttpClient((HttpClient)new TracingHttpClient(httpClient, (Tracer)(this.tracer == null ? NoopTracerFactory.create() : this.tracer)));
        return super.build();
    }
}

