/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.solr;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.solr.SolrTracingUtils;
import io.opentracing.tag.Tags;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public class TracingResponseHandler<T>
implements ResponseHandler<T> {
    private final ResponseHandler<T> responseHandler;
    private final Span span;
    private final Tracer tracer;

    public TracingResponseHandler(ResponseHandler<T> responseHandler, Span span, Tracer tracer) {
        this.responseHandler = responseHandler;
        this.span = span;
        this.tracer = tracer;
    }

    public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
        Tags.HTTP_STATUS.set(this.span, Integer.valueOf(response.getStatusLine().getStatusCode()));
        Throwable throwable = null;
        try (Scope ignored = this.tracer.scopeManager().activate(this.span);){
            Object object = this.responseHandler.handleResponse(response);
            return (T)object;
        }
        catch (Exception e) {
            try {
                SolrTracingUtils.onError(this.span, e);
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

