/*
 * Copyright (c) 2018-2019 Pivotal Software Inc, All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package reactor.blockhound.integration;

import com.google.auto.service.AutoService;
import reactor.blockhound.BlockHound;

/**
 *
 * @deprecated replaced by a more generic stdout/stderr solution: {@link StandardOutputIntegration}
 */
@Deprecated
@AutoService(BlockHoundIntegration.class)
public class LoggingIntegration implements BlockHoundIntegration {

    @Override
    public void applyTo(BlockHound.Builder builder) {
        try {
            Class.forName("org.gradle.internal.io.LineBufferingOutputStream");
            builder.allowBlockingCallsInside("org.gradle.internal.io.LineBufferingOutputStream", "write");
        } catch (ClassNotFoundException __) {
        }

        try {
            Class.forName("ch.qos.logback.classic.Logger");
            builder.allowBlockingCallsInside("ch.qos.logback.classic.Logger", "callAppenders");
        } catch (ClassNotFoundException e) {
        }
    }
}
