/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff;

import io.protostuff.ByteString;
import io.protostuff.LinkedBuffer;
import io.protostuff.Output;
import io.protostuff.Schema;
import io.protostuff.StringSerializer;
import io.protostuff.WireFormat;
import io.protostuff.WriteSession;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ProtobufOutput
extends WriteSession
implements Output {
    public static final int LITTLE_ENDIAN_32_SIZE = 4;
    public static final int LITTLE_ENDIAN_64_SIZE = 8;

    public ProtobufOutput(LinkedBuffer buffer) {
        super(buffer);
    }

    public ProtobufOutput(LinkedBuffer buffer, int nextBufferSize) {
        super(buffer, nextBufferSize);
    }

    public ProtobufOutput clear() {
        super.clear();
        return this;
    }

    public void writeInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.tail = value < 0 ? ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag((int)fieldNumber, (int)0), value, this, this.tail) : ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0), value, this, this.tail);
    }

    public void writeUInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0), value, this, this.tail);
    }

    public void writeSInt32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0), ProtobufOutput.encodeZigZag32(value), this, this.tail);
    }

    public void writeFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag((int)fieldNumber, (int)5), value, this, this.tail);
    }

    public void writeSFixed32(int fieldNumber, int value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag((int)fieldNumber, (int)5), value, this, this.tail);
    }

    public void writeInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag((int)fieldNumber, (int)0), value, this, this.tail);
    }

    public void writeUInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag((int)fieldNumber, (int)0), value, this, this.tail);
    }

    public void writeSInt64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt64(WireFormat.makeTag((int)fieldNumber, (int)0), ProtobufOutput.encodeZigZag64(value), this, this.tail);
    }

    public void writeFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag((int)fieldNumber, (int)1), value, this, this.tail);
    }

    public void writeSFixed64(int fieldNumber, long value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag((int)fieldNumber, (int)1), value, this, this.tail);
    }

    public void writeFloat(int fieldNumber, float value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian32(WireFormat.makeTag((int)fieldNumber, (int)5), Float.floatToRawIntBits(value), this, this.tail);
    }

    public void writeDouble(int fieldNumber, double value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawLittleEndian64(WireFormat.makeTag((int)fieldNumber, (int)1), Double.doubleToRawLongBits(value), this, this.tail);
    }

    public void writeBool(int fieldNumber, boolean value, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)0), value ? 1 : 0, this, this.tail);
    }

    public void writeEnum(int fieldNumber, int number, boolean repeated) throws IOException {
        this.writeInt32(fieldNumber, number, repeated);
    }

    public void writeString(int fieldNumber, String value, boolean repeated) throws IOException {
        this.tail = StringSerializer.writeUTF8VarDelimited((String)value, (WriteSession)this, (LinkedBuffer)ProtobufOutput.writeRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)2), this, this.tail));
    }

    public void writeBytes(int fieldNumber, ByteString value, boolean repeated) throws IOException {
        this.writeByteArray(fieldNumber, value.getBytes(), repeated);
    }

    public void writeByteArray(int fieldNumber, byte[] bytes, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndByteArray(WireFormat.makeTag((int)fieldNumber, (int)2), bytes, 0, bytes.length, this, this.tail);
    }

    public void writeByteRange(boolean utf8String, int fieldNumber, byte[] value, int offset, int length, boolean repeated) throws IOException {
        this.tail = ProtobufOutput.writeTagAndByteArray(WireFormat.makeTag((int)fieldNumber, (int)2), value, offset, length, this, this.tail);
    }

    public <T> void writeObject(int fieldNumber, T value, Schema<T> schema, boolean repeated) throws IOException {
        LinkedBuffer lastBuffer;
        if (fieldNumber < 16 && this.tail.offset != this.tail.buffer.length) {
            lastBuffer = this.tail;
            ++this.size;
            lastBuffer.buffer[lastBuffer.offset++] = (byte)WireFormat.makeTag((int)fieldNumber, (int)2);
        } else {
            this.tail = lastBuffer = ProtobufOutput.writeRawVarInt32(WireFormat.makeTag((int)fieldNumber, (int)2), this, this.tail);
        }
        int lastOffset = this.tail.offset;
        int lastSize = this.size++;
        if (lastOffset == lastBuffer.buffer.length) {
            LinkedBuffer nextBuffer;
            this.tail = nextBuffer = new LinkedBuffer(this.nextBufferSize);
            schema.writeTo((Output)this, value);
            int msgSize = this.size - lastSize;
            byte[] delimited = new byte[ProtobufOutput.computeRawVarint32Size(msgSize)];
            ProtobufOutput.writeRawVarInt32(msgSize, delimited, 0);
            this.size += delimited.length;
            new LinkedBuffer((byte[])delimited, (int)0, (int)delimited.length, (LinkedBuffer)lastBuffer).next = nextBuffer;
            return;
        }
        ++lastBuffer.offset;
        schema.writeTo((Output)this, value);
        int msgSize = this.size - lastSize - 1;
        if (msgSize < 128) {
            lastBuffer.buffer[lastOffset] = (byte)msgSize;
            return;
        }
        LinkedBuffer view = new LinkedBuffer(lastBuffer.buffer, lastOffset + 1, lastBuffer.offset);
        if (lastBuffer == this.tail) {
            this.tail = view;
        } else {
            view.next = lastBuffer.next;
        }
        lastBuffer.offset = lastOffset;
        byte[] delimited = new byte[ProtobufOutput.computeRawVarint32Size(msgSize)];
        ProtobufOutput.writeRawVarInt32(msgSize, delimited, 0);
        this.size += delimited.length - 1;
        new LinkedBuffer((byte[])delimited, (int)0, (int)delimited.length, (LinkedBuffer)lastBuffer).next = view;
    }

    public static LinkedBuffer writeRawVarInt32(int value, WriteSession session, LinkedBuffer lb) {
        int size = ProtobufOutput.computeRawVarint32Size(value);
        if (lb.offset + size > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += size;
        session.size += size;
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            int i = 0;
            int last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)(value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndLinkedBuffer(int tag, LinkedBuffer buffer, WriteSession session, LinkedBuffer lb) {
        int valueLen = buffer.offset - buffer.start;
        if (valueLen == 0) {
            return ProtobufOutput.writeTagAndRawVarInt32(tag, valueLen, session, lb);
        }
        lb = ProtobufOutput.writeTagAndRawVarInt32(tag, valueLen, session, lb);
        lb.next = buffer;
        int remaining = lb.buffer.length - lb.offset;
        return remaining == 0 ? new LinkedBuffer(session.nextBufferSize, buffer) : new LinkedBuffer(lb, buffer);
    }

    public static LinkedBuffer writeTagAndByteArray(int tag, byte[] value, int offset, int valueLen, WriteSession session, LinkedBuffer lb) {
        if (valueLen == 0) {
            return ProtobufOutput.writeTagAndRawVarInt32(tag, valueLen, session, lb);
        }
        lb = ProtobufOutput.writeTagAndRawVarInt32(tag, valueLen, session, lb);
        session.size += valueLen;
        int available = lb.buffer.length - lb.offset;
        if (valueLen > available) {
            if (available + session.nextBufferSize < valueLen) {
                if (available == 0) {
                    return new LinkedBuffer(session.nextBufferSize, new LinkedBuffer(value, offset, offset + valueLen, lb));
                }
                return new LinkedBuffer(lb, new LinkedBuffer(value, offset, offset + valueLen, lb));
            }
            System.arraycopy(value, offset, lb.buffer, lb.offset, available);
            lb.offset += available;
            lb = new LinkedBuffer(session.nextBufferSize, lb);
            int leftover = valueLen - available;
            System.arraycopy(value, offset + available, lb.buffer, 0, leftover);
            lb.offset += leftover;
            return lb;
        }
        System.arraycopy(value, offset, lb.buffer, lb.offset, valueLen);
        lb.offset += valueLen;
        return lb;
    }

    public static LinkedBuffer writeTagAndRawVarInt32(int tag, int value, WriteSession session, LinkedBuffer lb) {
        int last;
        int i;
        int size;
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int totalSize = tagSize + (size = ProtobufOutput.computeRawVarint32Size(value));
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)(value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndRawVarInt64(int tag, long value, WriteSession session, LinkedBuffer lb) {
        int last;
        int i;
        int size;
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int totalSize = tagSize + (size = ProtobufOutput.computeRawVarint64Size(value));
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)((int)value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return lb;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian32(int tag, int value, WriteSession session, LinkedBuffer lb) {
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int totalSize = tagSize + 4;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutput.writeRawLittleEndian32(value, buffer, offset);
        return lb;
    }

    public static LinkedBuffer writeTagAndRawLittleEndian64(int tag, long value, WriteSession session, LinkedBuffer lb) {
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int totalSize = tagSize + 8;
        if (lb.offset + totalSize > lb.buffer.length) {
            lb = new LinkedBuffer(session.nextBufferSize, lb);
        }
        byte[] buffer = lb.buffer;
        int offset = lb.offset;
        lb.offset += totalSize;
        session.size += totalSize;
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutput.writeRawLittleEndian64(value, buffer, offset);
        return lb;
    }

    public static void writeRawVarInt32(int value, byte[] buf, int offset) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                buf[offset] = (byte)value;
                return;
            }
            buf[offset++] = (byte)(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static void writeRawVarInt32Bytes(OutputStream out, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.write(value);
                return;
            }
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static void writeRawVarInt32Bytes(DataOutput out, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                out.write(value);
                return;
            }
            out.write(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static byte[] getTagAndRawVarInt32Bytes(int tag, int value) {
        int last;
        int i;
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int size = ProtobufOutput.computeRawVarint32Size(value);
        int offset = 0;
        byte[] buffer = new byte[tagSize + size];
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)(value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return buffer;
    }

    public static byte[] getTagAndRawVarInt64Bytes(int tag, long value) {
        int last;
        int i;
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int size = ProtobufOutput.computeRawVarint64Size(value);
        int offset = 0;
        byte[] buffer = new byte[tagSize + size];
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            i = 0;
            last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        if (size == 1) {
            buffer[offset] = (byte)value;
        } else {
            i = 0;
            last = size - 1;
            while (i < last) {
                buffer[offset++] = (byte)((int)value & 0x7F | 0x80);
                ++i;
                value >>>= 7;
            }
            buffer[offset] = (byte)value;
        }
        return buffer;
    }

    public static byte[] getTagAndRawLittleEndian32Bytes(int tag, int value) {
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int offset = 0;
        byte[] buffer = new byte[tagSize + 4];
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutput.writeRawLittleEndian32(value, buffer, offset);
        return buffer;
    }

    public static byte[] getTagAndRawLittleEndian64Bytes(int tag, long value) {
        int tagSize = ProtobufOutput.computeRawVarint32Size(tag);
        int offset = 0;
        byte[] buffer = new byte[tagSize + 8];
        if (tagSize == 1) {
            buffer[offset++] = (byte)tag;
        } else {
            int i = 0;
            int last = tagSize - 1;
            while (i < last) {
                buffer[offset++] = (byte)(tag & 0x7F | 0x80);
                ++i;
                tag >>>= 7;
            }
            buffer[offset++] = (byte)tag;
        }
        ProtobufOutput.writeRawLittleEndian64(value, buffer, offset);
        return buffer;
    }

    public static int writeRawLittleEndian32(int value, byte[] buffer, int offset) {
        if (buffer.length - offset < 4) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        buffer[offset++] = (byte)(value & 0xFF);
        buffer[offset++] = (byte)(value >> 8 & 0xFF);
        buffer[offset++] = (byte)(value >> 16 & 0xFF);
        buffer[offset] = (byte)(value >> 24 & 0xFF);
        return 4;
    }

    public static int writeRawLittleEndian64(long value, byte[] buffer, int offset) {
        if (buffer.length - offset < 8) {
            throw new IllegalArgumentException("buffer capacity not enough.");
        }
        buffer[offset++] = (byte)(value & 0xFFL);
        buffer[offset++] = (byte)(value >> 8 & 0xFFL);
        buffer[offset++] = (byte)(value >> 16 & 0xFFL);
        buffer[offset++] = (byte)(value >> 24 & 0xFFL);
        buffer[offset++] = (byte)(value >> 32 & 0xFFL);
        buffer[offset++] = (byte)(value >> 40 & 0xFFL);
        buffer[offset++] = (byte)(value >> 48 & 0xFFL);
        buffer[offset] = (byte)(value >> 56 & 0xFFL);
        return 8;
    }

    public static byte[] getRawVarInt32Bytes(int value) {
        int size = ProtobufOutput.computeRawVarint32Size(value);
        if (size == 1) {
            return new byte[]{(byte)value};
        }
        int offset = 0;
        byte[] buffer = new byte[size];
        int i = 0;
        int last = size - 1;
        while (i < last) {
            buffer[offset++] = (byte)(value & 0x7F | 0x80);
            ++i;
            value >>>= 7;
        }
        buffer[offset] = (byte)value;
        return buffer;
    }

    public static int computeRawVarint32Size(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeRawVarint64Size(long value) {
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((value & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public static int encodeZigZag32(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public void writeBytes(int fieldNumber, ByteBuffer value, boolean repeated) throws IOException {
        this.writeByteRange(false, fieldNumber, value.array(), value.arrayOffset() + value.position(), value.remaining(), repeated);
    }
}

