/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import rx.Observable;
import rx.Subscriber;

public class PublisherAdapter<T>
implements Publisher<T> {
    private final Observable<T> observable;
    private final Set<org.reactivestreams.Subscriber<?>> subscribers = new HashSet();

    public PublisherAdapter(Observable<T> observable) {
        this.observable = observable.serialize();
    }

    public void subscribe(final org.reactivestreams.Subscriber<? super T> s) {
        if (this.subscribers.add(s)) {
            this.observable.subscribe(new Subscriber<T>(){
                private final AtomicBoolean done = new AtomicBoolean();

                private void doRequest(long n) {
                    if (!this.done.get()) {
                        this.request(n);
                    }
                }

                public void onStart() {
                    final AtomicBoolean requested = new AtomicBoolean();
                    s.onSubscribe(new Subscription(){

                        public void request(long n) {
                            if (n < 1L) {
                                this.unsubscribe();
                                this.onError(new IllegalArgumentException("3.9 While the Subscription is not cancelled, Subscription.request(long n) MUST throw a java.lang.IllegalArgumentException if the argument is <= 0."));
                            }
                            requested.set(true);
                            this.doRequest(n);
                        }

                        public void cancel() {
                            this.unsubscribe();
                            this.fireDone();
                        }
                    });
                    if (!requested.get()) {
                        this.request(0L);
                    }
                }

                private boolean fireDone() {
                    boolean first = this.done.compareAndSet(false, true);
                    if (first) {
                        PublisherAdapter.this.subscribers.remove(s);
                    }
                    return first;
                }

                public void onCompleted() {
                    if (this.fireDone()) {
                        s.onComplete();
                    }
                }

                public void onError(Throwable e) {
                    if (this.fireDone()) {
                        s.onError(e);
                    }
                }

                public void onNext(T t) {
                    if (!this.done.get()) {
                        s.onNext(t);
                    }
                }
            });
        } else {
            s.onError((Throwable)new IllegalArgumentException("1.10 Subscriber cannot subscribe more than once"));
        }
    }
}

