/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.ArrayList;
import java.util.List;
import rx.Producer;
import rx.Subscription;

public final class RxJavaSynchronizedProducer
implements Producer,
Subscription {
    private final org.reactivestreams.Subscription subscription;
    private volatile boolean unsubscribed;
    private boolean emitting;
    private List<Long> requests;

    public RxJavaSynchronizedProducer(org.reactivestreams.Subscription subscription) {
        if (subscription == null) {
            throw new NullPointerException("subscription");
        }
        this.subscription = subscription;
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void request(long n) {
        if (n <= 0L) return;
        if (this.unsubscribed) return;
        RxJavaSynchronizedProducer rxJavaSynchronizedProducer = this;
        synchronized (rxJavaSynchronizedProducer) {
            if (this.unsubscribed) {
                return;
            }
            if (this.emitting) {
                if (this.requests == null) {
                    this.requests = new ArrayList<Long>(4);
                }
                this.requests.add(n);
                return;
            }
            this.emitting = true;
        }
        boolean skipFinal = false;
        try {
            this.subscription.request(n);
            block16: while (true) {
                List<Long> list;
                Object object = this;
                synchronized (object) {
                    list = this.requests;
                    this.requests = null;
                    if (list == null) {
                        this.emitting = false;
                        skipFinal = true;
                        return;
                    }
                }
                object = list.iterator();
                while (true) {
                    if (!object.hasNext()) continue block16;
                    Long v = (Long)object.next();
                    if (v == 0L) {
                        this.unsubscribed = true;
                        this.subscription.cancel();
                        skipFinal = true;
                        return;
                    }
                    this.subscription.request(v.longValue());
                }
                break;
            }
        }
        finally {
            if (!skipFinal) {
                RxJavaSynchronizedProducer rxJavaSynchronizedProducer2 = this;
                synchronized (rxJavaSynchronizedProducer2) {
                    this.emitting = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        if (!this.unsubscribed) {
            RxJavaSynchronizedProducer rxJavaSynchronizedProducer = this;
            synchronized (rxJavaSynchronizedProducer) {
                if (this.unsubscribed) {
                    return;
                }
                if (this.emitting) {
                    this.requests = new ArrayList<Long>(4);
                    this.requests.add(0L);
                    return;
                }
                this.emitting = true;
            }
            this.unsubscribed = true;
            this.subscription.cancel();
        }
    }
}

