/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.observers.SerializedSubscriber;
import rx.subscriptions.SerialSubscription;
import rx.subscriptions.Subscriptions;

public final class OperatorConcat<T>
implements Observable.Operator<T, Observable<? extends T>> {
    public static <T> OperatorConcat<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorConcat() {
    }

    @Override
    public Subscriber<? super Observable<? extends T>> call(Subscriber<? super T> child) {
        SerializedSubscriber<? super T> s = new SerializedSubscriber<T>(child);
        SerialSubscription current = new SerialSubscription();
        child.add(current);
        ConcatSubscriber<? super T> cs = new ConcatSubscriber<T>(s, current);
        ConcatProducer<? super T> cp = new ConcatProducer<T>(cs);
        child.setProducer(cp);
        return cs;
    }

    static class ConcatInnerSubscriber<T>
    extends Subscriber<T> {
        private final Subscriber<T> child;
        private final ConcatSubscriber<T> parent;
        private volatile int once = 0;
        private static final AtomicIntegerFieldUpdater<ConcatInnerSubscriber> ONCE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConcatInnerSubscriber.class, "once");

        public ConcatInnerSubscriber(ConcatSubscriber<T> parent, Subscriber<T> child, long initialRequest) {
            this.parent = parent;
            this.child = child;
            this.request(initialRequest);
        }

        void requestMore(long n) {
            this.request(n);
        }

        @Override
        public void onNext(T t) {
            ((ConcatSubscriber)this.parent).decrementRequested();
            this.child.onNext(t);
        }

        @Override
        public void onError(Throwable e) {
            if (ONCE_UPDATER.compareAndSet(this, 0, 1)) {
                this.parent.onError(e);
            }
        }

        @Override
        public void onCompleted() {
            if (ONCE_UPDATER.compareAndSet(this, 0, 1)) {
                this.parent.completeInner();
            }
        }
    }

    static final class ConcatSubscriber<T>
    extends Subscriber<Observable<? extends T>> {
        final NotificationLite<Observable<? extends T>> nl = NotificationLite.instance();
        private final Subscriber<T> child;
        private final SerialSubscription current;
        final ConcurrentLinkedQueue<Object> queue;
        volatile ConcatInnerSubscriber<T> currentSubscriber;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ConcatSubscriber> WIP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConcatSubscriber.class, "wip");
        private volatile long requested;
        private static final AtomicLongFieldUpdater<ConcatSubscriber> REQUESTED_UPDATER = AtomicLongFieldUpdater.newUpdater(ConcatSubscriber.class, "requested");

        public ConcatSubscriber(Subscriber<T> s, SerialSubscription current) {
            super(s);
            this.child = s;
            this.current = current;
            this.queue = new ConcurrentLinkedQueue();
            this.add(Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    ConcatSubscriber.this.queue.clear();
                }
            }));
        }

        @Override
        public void onStart() {
            this.request(2L);
        }

        private void requestFromChild(long n) {
            ConcatInnerSubscriber<T> actualSubscriber = this.currentSubscriber;
            if (n > 0L && BackpressureUtils.getAndAddRequest(REQUESTED_UPDATER, this, n) == 0L && actualSubscriber == null && this.wip > 0) {
                this.subscribeNext();
                return;
            }
            if (actualSubscriber != null) {
                actualSubscriber.requestMore(n);
            }
        }

        private void decrementRequested() {
            REQUESTED_UPDATER.decrementAndGet(this);
        }

        @Override
        public void onNext(Observable<? extends T> t) {
            this.queue.add(this.nl.next(t));
            if (WIP_UPDATER.getAndIncrement(this) == 0) {
                this.subscribeNext();
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
            this.unsubscribe();
        }

        @Override
        public void onCompleted() {
            this.queue.add(this.nl.completed());
            if (WIP_UPDATER.getAndIncrement(this) == 0) {
                this.subscribeNext();
            }
        }

        void completeInner() {
            this.currentSubscriber = null;
            if (WIP_UPDATER.decrementAndGet(this) > 0) {
                this.subscribeNext();
            }
            this.request(1L);
        }

        void subscribeNext() {
            if (this.requested > 0L) {
                Object o = this.queue.poll();
                if (this.nl.isCompleted(o)) {
                    this.child.onCompleted();
                } else if (o != null) {
                    Observable<T> obs = this.nl.getValue(o);
                    this.currentSubscriber = new ConcatInnerSubscriber<T>(this, this.child, this.requested);
                    this.current.set(this.currentSubscriber);
                    obs.unsafeSubscribe(this.currentSubscriber);
                }
            } else {
                Object o = this.queue.peek();
                if (this.nl.isCompleted(o)) {
                    this.child.onCompleted();
                }
            }
        }
    }

    static final class ConcatProducer<T>
    implements Producer {
        final ConcatSubscriber<T> cs;

        ConcatProducer(ConcatSubscriber<T> cs) {
            this.cs = cs;
        }

        @Override
        public void request(long n) {
            ((ConcatSubscriber)this.cs).requestFromChild(n);
        }
    }

    private static final class Holder {
        static final OperatorConcat<Object> INSTANCE = new OperatorConcat();

        private Holder() {
        }
    }
}

