/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LogLevel;
import io.netty.util.concurrent.EventExecutorGroup;
import io.reactivex.netty.client.ChannelProviderFactory;
import io.reactivex.netty.client.ConnectionProviderFactory;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.protocol.http.client.HttpClientImpl;
import io.reactivex.netty.protocol.http.client.InterceptingHttpClient;
import io.reactivex.netty.ssl.SslCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;

public abstract class HttpClient<I, O>
extends InterceptingHttpClient<I, O> {
    public abstract HttpClient<I, O> readTimeOut(int var1, TimeUnit var2);

    public abstract <T> HttpClient<I, O> channelOption(ChannelOption<T> var1, T var2);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerFirst(String var1, Func0<ChannelHandler> var2);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerFirst(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerLast(String var1, Func0<ChannelHandler> var2);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerLast(EventExecutorGroup var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerBefore(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerBefore(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerAfter(String var1, String var2, Func0<ChannelHandler> var3);

    public abstract <II, OO> HttpClient<II, OO> addChannelHandlerAfter(EventExecutorGroup var1, String var2, String var3, Func0<ChannelHandler> var4);

    public abstract <II, OO> HttpClient<II, OO> pipelineConfigurator(Action1<ChannelPipeline> var1);

    public abstract HttpClient<I, O> secure(Func1<ByteBufAllocator, SSLEngine> var1);

    public abstract HttpClient<I, O> secure(SSLEngine var1);

    public abstract HttpClient<I, O> secure(SslCodec var1);

    public abstract HttpClient<I, O> unsafeSecure();

    public abstract HttpClient<I, O> enableWireLogging(LogLevel var1);

    public abstract HttpClient<I, O> channelProvider(ChannelProviderFactory var1);

    public static HttpClient<ByteBuf, ByteBuf> newClient(String host, int port) {
        return HttpClient.newClient(new InetSocketAddress(host, port));
    }

    public static HttpClient<ByteBuf, ByteBuf> newClient(SocketAddress serverAddress) {
        return HttpClientImpl.create(serverAddress);
    }

    public static HttpClient<ByteBuf, ByteBuf> newClient(ConnectionProviderFactory<ByteBuf, ByteBuf> providerFactory, Observable<Host> hostStream) {
        return HttpClientImpl.create(providerFactory, hostStream);
    }

    public abstract HttpClient<I, O> followRedirects(int var1);

    public abstract HttpClient<I, O> followRedirects(boolean var1);
}

